/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.autoimport.CachingExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import icons.GradleIcons;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradleAutoImportAware;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleManager
implements ExternalSystemConfigurableAware,
ExternalSystemUiAware,
ExternalSystemAutoImportAware,
StartupActivity,
ExternalSystemManager<GradleProjectSettings, GradleSettingsListener, GradleSettings, GradleLocalSettings, GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance((String)("#" + GradleManager.class.getName()));
    private final ExternalSystemAutoImportAware myAutoImportDelegate = new CachingExternalSystemAutoImportAware((ExternalSystemAutoImportAware)new GradleAutoImportAware());
    private final GradleInstallationManager myInstallationManager;
    private static final NotNullLazyValue<List<GradleProjectResolverExtension>> RESOLVER_EXTENSIONS = new AtomicNotNullLazyValue<List<GradleProjectResolverExtension>>(){

        protected List<GradleProjectResolverExtension> compute() {
            ArrayList result = ContainerUtilRt.newArrayList();
            Collections.addAll(result, GradleProjectResolverExtension.EP_NAME.getExtensions());
            ExternalSystemApiUtil.orderAwareSort((List)result);
            return result;
        }
    };

    public GradleManager(GradleInstallationManager manager) {
        this.myInstallationManager = manager;
    }

    public ProjectSystemId getSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    public Function<Project, GradleSettings> getSettingsProvider() {
        return new Function<Project, GradleSettings>(){

            public GradleSettings fun(Project project) {
                return GradleSettings.getInstance(project);
            }
        };
    }

    public Function<Project, GradleLocalSettings> getLocalSettingsProvider() {
        return new Function<Project, GradleLocalSettings>(){

            public GradleLocalSettings fun(Project project) {
                return GradleLocalSettings.getInstance(project);
            }
        };
    }

    public Function<Pair<Project, String>, GradleExecutionSettings> getExecutionSettingsProvider() {
        return new Function<Pair<Project, String>, GradleExecutionSettings>(){

            public GradleExecutionSettings fun(Pair<Project, String> pair) {
                String javaHome;
                GradleProjectSettings projectLevelSettings;
                GradleSettings settings = GradleSettings.getInstance((Project)pair.first);
                File gradleHome = GradleManager.this.myInstallationManager.getGradleHome((Project)pair.first, (String)pair.second);
                String localGradlePath = null;
                if (gradleHome != null) {
                    try {
                        localGradlePath = gradleHome.getCanonicalPath();
                    }
                    catch (IOException e) {
                        localGradlePath = gradleHome.getAbsolutePath();
                    }
                }
                DistributionType distributionType = (projectLevelSettings = (GradleProjectSettings)settings.getLinkedProjectSettings((String)pair.second)) == null ? (GradleUtil.isGradleDefaultWrapperFilesExist((String)pair.second) ? DistributionType.DEFAULT_WRAPPED : DistributionType.LOCAL) : (projectLevelSettings.getDistributionType() == null ? DistributionType.LOCAL : projectLevelSettings.getDistributionType());
                GradleExecutionSettings result = new GradleExecutionSettings(localGradlePath, settings.getServiceDirectoryPath(), distributionType, settings.getGradleVmOptions(), settings.isOfflineWork());
                for (GradleProjectResolverExtension extension : (List)RESOLVER_EXTENSIONS.getValue()) {
                    result.addResolverExtensionClass(ClassHolder.from(extension.getClass()));
                }
                Sdk gradleJdk = GradleManager.this.myInstallationManager.getGradleJdk((Project)pair.first, (String)pair.second);
                String string = javaHome = gradleJdk != null ? gradleJdk.getHomePath() : null;
                if (!StringUtil.isEmpty((String)javaHome)) {
                    LOG.info("Instructing gradle to use java from " + javaHome);
                }
                result.setJavaHome(javaHome);
                return result;
            }
        };
    }

    public void enhanceRemoteProcessing(SimpleJavaParameters parameters) throws ExecutionException {
        HashSet additionalEntries = ContainerUtilRt.newHashSet();
        for (GradleProjectResolverExtension extension : (List)RESOLVER_EXTENSIONS.getValue()) {
            ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(extension.getClass()));
            for (Class aClass : extension.getExtraProjectModelClasses()) {
                ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass((Class)aClass));
            }
            extension.enhanceRemoteProcessing(parameters);
        }
        PathsList classPath = parameters.getClassPath();
        for (String entry : additionalEntries) {
            classPath.add(entry);
        }
        parameters.getVMParametersList().addProperty("external.system.id", GradleConstants.SYSTEM_ID.getId());
    }

    public void enhanceLocalProcessing(List<URL> urls) {
    }

    public Class<? extends ExternalSystemProjectResolver<GradleExecutionSettings>> getProjectResolverClass() {
        return GradleProjectResolver.class;
    }

    public Class<? extends ExternalSystemTaskManager<GradleExecutionSettings>> getTaskManagerClass() {
        return GradleTaskManager.class;
    }

    public Configurable getConfigurable(Project project) {
        return new GradleConfigurable(project);
    }

    public FileChooserDescriptor getExternalProjectConfigDescriptor() {
        return GradleUtil.getGradleProjectFileChooserDescriptor();
    }

    public Icon getProjectIcon() {
        return GradleIcons.Gradle;
    }

    public Icon getTaskIcon() {
        return DefaultExternalSystemUiAware.INSTANCE.getTaskIcon();
    }

    public String getProjectRepresentationName(String targetProjectPath, String rootProjectPath) {
        return ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
    }

    public String getAffectedExternalProjectPath(String changedFileOrDirPath, Project project) {
        return this.myAutoImportDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project);
    }

    public FileChooserDescriptor getExternalProjectDescriptor() {
        return GradleUtil.getGradleProjectFileChooserDescriptor();
    }

    public void runActivity(final Project project) {
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(GradleSettings.getInstance(project).getChangesTopic(), (Object)new GradleSettingsListenerAdapter(){

            @Override
            public void onServiceDirectoryPathChange(String oldPath, String newPath) {
                this.ensureProjectsRefresh();
            }

            @Override
            public void onGradleHomeChange(String oldPath, String newPath, String linkedProjectPath) {
                this.ensureProjectsRefresh();
            }

            @Override
            public void onGradleDistributionTypeChange(DistributionType currentValue, String linkedProjectPath) {
                this.ensureProjectsRefresh();
            }

            private void ensureProjectsRefresh() {
                ExternalSystemUtil.refreshProjects((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (boolean)true);
            }
        });
        Map<String, String> adjustedPaths = GradleManager.patchLinkedProjects(project);
        if (adjustedPaths == null) {
            return;
        }
        GradleLocalSettings localSettings = GradleLocalSettings.getInstance(project);
        GradleManager.patchRecentTasks(adjustedPaths, localSettings);
        GradleManager.patchAvailableProjects(adjustedPaths, localSettings);
        GradleManager.patchAvailableTasks(adjustedPaths, localSettings);
    }

    private static Map<String, String> patchLinkedProjects(Project project) {
        GradleSettings settings = GradleSettings.getInstance(project);
        ArrayList correctedSettings = ContainerUtilRt.newArrayList();
        HashMap adjustedPaths = ContainerUtilRt.newHashMap();
        for (GradleProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            String oldPath = projectSettings.getExternalProjectPath();
            if (oldPath != null && new File(oldPath).isFile() && FileUtilRt.extensionEquals((String)oldPath, (String)"gradle")) {
                try {
                    String newPath = new File(oldPath).getParentFile().getCanonicalPath();
                    projectSettings.setExternalProjectPath(newPath);
                    adjustedPaths.put(oldPath, newPath);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unexpected exception occurred on attempt to re-point linked gradle project path from build.gradle to its parent dir. Path: %s", oldPath), (Throwable)e);
                }
            }
            correctedSettings.add(projectSettings);
        }
        if (adjustedPaths.isEmpty()) {
            return null;
        }
        settings.setLinkedProjectsSettings(correctedSettings);
        return adjustedPaths;
    }

    private static void patchAvailableTasks(Map<String, String> adjustedPaths, GradleLocalSettings localSettings) {
        HashMap adjustedAvailableTasks = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : localSettings.getAvailableTasks().entrySet()) {
            String newPath = adjustedPaths.get(entry.getKey());
            if (newPath == null) {
                adjustedAvailableTasks.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (ExternalTaskPojo task : (Collection)entry.getValue()) {
                String newTaskPath = adjustedPaths.get(task.getLinkedExternalProjectPath());
                if (newTaskPath == null) continue;
                task.setLinkedExternalProjectPath(newTaskPath);
            }
            adjustedAvailableTasks.put(newPath, entry.getValue());
        }
        localSettings.setAvailableTasks(adjustedAvailableTasks);
    }

    private static void patchAvailableProjects(Map<String, String> adjustedPaths, GradleLocalSettings localSettings) {
        HashMap adjustedAvailableProjects = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : localSettings.getAvailableProjects().entrySet()) {
            String newPath = adjustedPaths.get(((ExternalProjectPojo)entry.getKey()).getPath());
            if (newPath == null) {
                adjustedAvailableProjects.put(entry.getKey(), entry.getValue());
                continue;
            }
            adjustedAvailableProjects.put(new ExternalProjectPojo(((ExternalProjectPojo)entry.getKey()).getName(), newPath), entry.getValue());
        }
        localSettings.setAvailableProjects(adjustedAvailableProjects);
    }

    private static void patchRecentTasks(Map<String, String> adjustedPaths, GradleLocalSettings localSettings) {
        for (ExternalTaskExecutionInfo taskInfo : localSettings.getRecentTasks()) {
            ExternalSystemTaskExecutionSettings s = taskInfo.getSettings();
            String newPath = adjustedPaths.get(s.getExternalProjectPath());
            if (newPath == null) continue;
            s.setExternalProjectPath(newPath);
        }
    }
}

