/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TabbedTerminalWidget;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalWidget;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalView {
    private JBTabbedTerminalWidget myTerminalWidget;
    private final Project myProject;
    private TerminalDockContainer myDockContainer;

    public TerminalView(Project project) {
        this.myProject = project;
    }

    public static TerminalView getInstance(Project project) {
        return (TerminalView)project.getComponent(TerminalView.class);
    }

    public void initTerminal(final ToolWindow toolWindow) {
        LocalTerminalDirectRunner terminalRunner = LocalTerminalDirectRunner.createTerminalRunner(this.myProject);
        toolWindow.setToHideOnEmptyContent(true);
        if (terminalRunner != null) {
            Content content = this.createTerminalInContentPanel(terminalRunner, toolWindow);
            toolWindow.getContentManager().addContent(content);
            ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener(new ToolWindowManagerListener(){

                public void toolWindowRegistered(String id) {
                }

                public void stateChanged() {
                    boolean visible;
                    ToolWindow window = ToolWindowManager.getInstance((Project)TerminalView.this.myProject).getToolWindow("Terminal");
                    if (window != null && (visible = window.isVisible()) && toolWindow.getContentManager().getContentCount() == 0) {
                        TerminalView.this.initTerminal(window);
                    }
                }
            });
            Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                public void dispose() {
                    if (TerminalView.this.myTerminalWidget != null) {
                        TerminalView.this.myTerminalWidget.dispose();
                        TerminalView.this.myTerminalWidget = null;
                    }
                }
            });
        }
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer(toolWindow);
            Disposer.register((Disposable)this.myProject, (Disposable)this.myDockContainer);
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer);
        }
    }

    private Content createTerminalInContentPanel(AbstractTerminalRunner terminalRunner, final ToolWindow toolWindow) {
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, "", false);
        content.setCloseable(true);
        this.myTerminalWidget = terminalRunner.createTerminalWidget((Disposable)content);
        this.myTerminalWidget.addTabListener(new TabbedTerminalWidget.TabListener(){

            public void tabClosed(JediTermWidget terminal) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (TerminalView.this.myTerminalWidget != null) {
                            TerminalView.hideIfNoActiveSessions(toolWindow, TerminalView.this.myTerminalWidget);
                        }
                    }
                });
            }
        });
        panel.setContent(this.myTerminalWidget.getComponent());
        panel.addFocusListener(this.createFocusListener());
        ActionToolbar toolbar = this.createToolbar(terminalRunner, this.myTerminalWidget, toolWindow);
        toolbar.getComponent().addFocusListener(this.createFocusListener());
        toolbar.setTargetComponent((JComponent)panel);
        panel.setToolbar(toolbar.getComponent());
        content.setPreferredFocusableComponent(this.myTerminalWidget.getComponent());
        return content;
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = TerminalView.this.getComponentToFocus();
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    private JComponent getComponentToFocus() {
        return this.myTerminalWidget != null ? this.myTerminalWidget.getComponent() : null;
    }

    public void openLocalSession(Project project, ToolWindow terminal) {
        LocalTerminalDirectRunner terminalRunner = LocalTerminalDirectRunner.createTerminalRunner(project);
        this.openSession(terminal, terminalRunner);
    }

    private void openSession(ToolWindow toolWindow, AbstractTerminalRunner terminalRunner) {
        if (this.myTerminalWidget == null) {
            toolWindow.getContentManager().removeAllContents(true);
            Content content = this.createTerminalInContentPanel(terminalRunner, toolWindow);
            toolWindow.getContentManager().addContent(content);
        } else {
            terminalRunner.openSession((TerminalWidget)this.myTerminalWidget);
        }
        toolWindow.activate(new Runnable(){

            @Override
            public void run() {
            }
        }, true);
    }

    private ActionToolbar createToolbar(AbstractTerminalRunner terminalRunner, JBTabbedTerminalWidget terminal, ToolWindow toolWindow) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (terminalRunner != null) {
            group.add((AnAction)new NewSession(terminalRunner, (TerminalWidget)terminal));
            group.add((AnAction)new CloseSession(terminal, toolWindow));
        }
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false);
    }

    public void createNewSession(Project project, final AbstractTerminalRunner terminalRunner) {
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        toolWindow.activate(new Runnable(){

            @Override
            public void run() {
                TerminalView.this.openSession(toolWindow, terminalRunner);
            }
        }, true);
    }

    private static void hideIfNoActiveSessions(ToolWindow toolWindow, JBTabbedTerminalWidget terminal) {
        if (terminal.isNoActiveSessions()) {
            toolWindow.getContentManager().removeAllContents(true);
        }
    }

    public class TerminalDockContainer
    implements DockContainer {
        private ToolWindow myTerminalToolWindow;

        public TerminalDockContainer(ToolWindow toolWindow) {
            this.myTerminalToolWindow = toolWindow;
        }

        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(this.myTerminalToolWindow.getComponent());
        }

        public RelativeRectangle getAcceptAreaFallback() {
            return this.getAcceptArea();
        }

        public DockContainer.ContentResponse getContentResponse(DockableContent content, RelativePoint point) {
            return this.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        }

        public JComponent getContainerComponent() {
            return this.myTerminalToolWindow.getComponent();
        }

        public void add(DockableContent content, RelativePoint dropTarget) {
            if (this.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                TerminalView.this.myTerminalWidget.addTab(terminalFile.getName(), terminalFile.getTerminal());
                terminalFile.getTerminal().setNextProvider((TerminalActionProvider)TerminalView.this.myTerminalWidget);
            }
        }

        private boolean isTerminalSessionContent(DockableContent content) {
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public void closeAll() {
        }

        public void addListener(DockContainer.Listener listener, Disposable parent) {
        }

        public boolean isEmpty() {
            return false;
        }

        public Image startDropOver(DockableContent content, RelativePoint point) {
            return null;
        }

        public Image processDropOver(DockableContent content, RelativePoint point) {
            return null;
        }

        public void resetDropOver(DockableContent content) {
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        public void showNotify() {
        }

        public void hideNotify() {
        }

        public void dispose() {
        }
    }

    private class CloseSession
    extends DumbAwareAction {
        private final JBTabbedTerminalWidget myTerminal;
        private ToolWindow myToolWindow;

        public CloseSession(JBTabbedTerminalWidget terminal, ToolWindow toolWindow) {
            super("Close Session", "Close Terminal Session", AllIcons.Actions.Delete);
            this.myTerminal = terminal;
            this.myToolWindow = toolWindow;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myTerminal.closeCurrentSession();
            TerminalView.hideIfNoActiveSessions(this.myToolWindow, this.myTerminal);
        }
    }

    private static class NewSession
    extends DumbAwareAction {
        private final AbstractTerminalRunner myTerminalRunner;
        private final TerminalWidget myTerminal;

        public NewSession(AbstractTerminalRunner terminalRunner, TerminalWidget terminal) {
            super("New Session", "Create New Terminal Session", AllIcons.General.Add);
            this.myTerminalRunner = terminalRunner;
            this.myTerminal = terminal;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myTerminalRunner.openSession(this.myTerminal);
        }
    }
}

