/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc;

import groovy.lang.Reference;
import groovy.transform.CompileStatic;
import groovy.transform.TypeChecked;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.classgen.asm.TypeChooser;
import org.codehaus.groovy.classgen.asm.WriterControllerFactory;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesTypeChooser;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticCompilationVisitor
extends StaticTypeCheckingVisitor {
    private static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    private static final ClassNode COMPILESTATIC_CLASSNODE = ClassHelper.make(CompileStatic.class);
    private static final ClassNode[] TYPECHECKED_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE, COMPILESTATIC_CLASSNODE};
    public static final ClassNode ARRAYLIST_CLASSNODE = ClassHelper.make(ArrayList.class);
    public static final MethodNode ARRAYLIST_CONSTRUCTOR;
    public static final MethodNode ARRAYLIST_ADD_METHOD;
    private final TypeChooser typeChooser = new StaticTypesTypeChooser();
    private ClassNode classNode;

    public StaticCompilationVisitor(SourceUnit unit, ClassNode node) {
        super(unit, node);
    }

    @Override
    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKED_ANNOTATIONS;
    }

    public static boolean isStaticallyCompiled(AnnotatedNode node) {
        if (node.getNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE) != null) {
            return (Boolean)node.getNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE);
        }
        if (node instanceof MethodNode) {
            return StaticCompilationVisitor.isStaticallyCompiled(node.getDeclaringClass());
        }
        if (node instanceof InnerClassNode) {
            return StaticCompilationVisitor.isStaticallyCompiled(((InnerClassNode)node).getOuterClass());
        }
        return false;
    }

    private void addPrivateFieldAndMethodAccessors(ClassNode node) {
        this.addPrivateBridgeMethods(node);
        this.addPrivateFieldsAccessors(node);
        Iterator<InnerClassNode> it = node.getInnerClasses();
        while (it.hasNext()) {
            this.addPrivateFieldAndMethodAccessors(it.next());
        }
    }

    @Override
    public void visitClass(ClassNode node) {
        boolean skip = this.shouldSkipClassNode(node);
        ClassNode oldCN = this.classNode;
        this.classNode = node;
        Iterator<InnerClassNode> innerClasses = this.classNode.getInnerClasses();
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            innerClassNode.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, !skip && !this.isSkippedInnerClass(innerClassNode));
            innerClassNode.putNodeMetaData(WriterControllerFactory.class, node.getNodeMetaData(WriterControllerFactory.class));
        }
        super.visitClass(node);
        this.addPrivateFieldAndMethodAccessors(node);
        this.classNode = oldCN;
    }

    private void checkForConstructorWithCSButClassWithout(MethodNode node) {
        if (!(node instanceof ConstructorNode)) {
            return;
        }
        Object meta = node.getNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE);
        if (!Boolean.TRUE.equals(meta)) {
            return;
        }
        ClassNode clz = this.typeCheckingContext.getEnclosingClassNode();
        meta = clz.getNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE);
        if (Boolean.TRUE.equals(meta)) {
            return;
        }
        if (clz.getObjectInitializerStatements().isEmpty() && clz.getFields().isEmpty() && clz.getProperties().isEmpty()) {
            return;
        }
        this.addStaticTypeError("Cannot statically compile constructor implicitly including non static elements from object initializers, properties or fields.", node);
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.isSkipMode(node)) {
            node.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, false);
        }
        super.visitMethod(node);
        this.checkForConstructorWithCSButClassWithout(node);
    }

    private void addPrivateFieldsAccessors(ClassNode node) {
        Set accessedFields = (Set)node.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_ACCESS);
        if (accessedFields == null) {
            return;
        }
        HashMap<String, MethodNode> privateConstantAccessors = (HashMap<String, MethodNode>)node.getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_FIELDS_ACCESSORS);
        if (privateConstantAccessors != null) {
            return;
        }
        int acc = -1;
        privateConstantAccessors = new HashMap<String, MethodNode>();
        int access = 4105;
        for (FieldNode fieldNode : node.getFields()) {
            if (!accessedFields.contains(fieldNode)) continue;
            Parameter param = new Parameter(node.getPlainNodeReference(), "$that");
            Expression receiver = fieldNode.isStatic() ? new ClassExpression(node) : new VariableExpression(param);
            ExpressionStatement stmt = new ExpressionStatement(new PropertyExpression(receiver, fieldNode.getName()));
            MethodNode accessor = node.addMethod("pfaccess$" + ++acc, 4105, fieldNode.getOriginType(), new Parameter[]{param}, ClassNode.EMPTY_ARRAY, stmt);
            privateConstantAccessors.put(fieldNode.getName(), accessor);
        }
        node.setNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_FIELDS_ACCESSORS, privateConstantAccessors);
    }

    private void addPrivateBridgeMethods(ClassNode node) {
        Set accessedMethods = (Set)node.getNodeMetaData((Object)StaticTypesMarker.PV_METHODS_ACCESS);
        if (accessedMethods == null) {
            return;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>(node.getAllDeclaredMethods());
        HashMap<MethodNode, MethodNode> privateBridgeMethods = (HashMap<MethodNode, MethodNode>)node.getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_BRIDGE_METHODS);
        if (privateBridgeMethods != null) {
            return;
        }
        privateBridgeMethods = new HashMap<MethodNode, MethodNode>();
        int i = -1;
        int access = 4105;
        for (MethodNode method : methods) {
            ArgumentListExpression arguments;
            if (!accessedMethods.contains(method)) continue;
            ++i;
            Parameter[] methodParameters = method.getParameters();
            Parameter[] newParams = new Parameter[methodParameters.length + 1];
            System.arraycopy(methodParameters, 0, newParams, 1, methodParameters.length);
            newParams[0] = new Parameter(node.getPlainNodeReference(), "$that");
            if (method.getParameters() == null || method.getParameters().length == 0) {
                arguments = ArgumentListExpression.EMPTY_ARGUMENTS;
            } else {
                LinkedList<Expression> args = new LinkedList<Expression>();
                for (Parameter parameter : methodParameters) {
                    args.add(new VariableExpression(parameter));
                }
                arguments = new ArgumentListExpression(args);
            }
            Expression receiver = method.isStatic() ? new ClassExpression(node) : new VariableExpression(newParams[0]);
            MethodCallExpression mce = new MethodCallExpression(receiver, method.getName(), (Expression)arguments);
            mce.setMethodTarget(method);
            ExpressionStatement returnStatement = new ExpressionStatement(mce);
            MethodNode bridge = node.addMethod("access$" + i, 4105, method.getReturnType(), newParams, method.getExceptions(), returnStatement);
            privateBridgeMethods.put(method, bridge);
            bridge.addAnnotation(new AnnotationNode(COMPILESTATIC_CLASSNODE));
        }
        if (!privateBridgeMethods.isEmpty()) {
            node.setNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_BRIDGE_METHODS, privateBridgeMethods);
        }
    }

    private void memorizeInitialExpressions(MethodNode node) {
        if (node.getParameters() != null) {
            for (Parameter parameter : node.getParameters()) {
                parameter.putNodeMetaData((Object)StaticTypesMarker.INITIAL_EXPRESSION, parameter.getInitialExpression());
            }
        }
    }

    @Override
    public void visitSpreadExpression(SpreadExpression expression) {
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        super.visitMethodCallExpression(call);
        MethodNode target = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (target != null) {
            call.setMethodTarget(target);
            this.memorizeInitialExpressions(target);
        }
        if (call.getMethodTarget() == null && call.getLineNumber() > 0) {
            this.addError("Target method for method call expression hasn't been set", call);
        }
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        MethodNode target = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (target == null && call.getLineNumber() > 0) {
            this.addError("Target constructor for constructor call expression hasn't been set", call);
        } else if (target == null) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(call.getArguments());
            List<Expression> expressions = argumentListExpression.getExpressions();
            ClassNode[] args = new ClassNode[expressions.size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.typeChooser.resolveType(expressions.get(i), this.classNode);
            }
            MethodNode constructor = this.findMethodOrFail(call, call.isSuperCall() ? this.classNode.getSuperClass() : this.classNode, "<init>", args);
            call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, constructor);
            target = constructor;
        }
        if (target != null) {
            this.memorizeInitialExpressions(target);
        }
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        super.visitForLoop(forLoop);
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (!(collectionExpression instanceof ClosureListExpression)) {
            ClassNode collectionType = this.getType(forLoop.getCollectionExpression());
            ClassNode componentType = StaticCompilationVisitor.inferLoopElementType(collectionType);
            forLoop.getVariable().setType(componentType);
            forLoop.getVariable().setOriginType(componentType);
        }
    }

    @Override
    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        MethodNode methodNode = super.findMethodOrFail(expr, receiver, name, args);
        if (expr instanceof BinaryExpression && methodNode != null) {
            expr.putNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET, new Object[]{methodNode, name});
        }
        return methodNode;
    }

    @Override
    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly, final ClassCodeVisitorSupport visitor) {
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode objectExpressionType = this.getType(objectExpression);
        final Reference<ClassNode> rType = new Reference<ClassNode>(objectExpressionType);
        ClassCodeVisitorSupport receiverMemoizer = new ClassCodeVisitorSupport(){

            @Override
            protected SourceUnit getSourceUnit() {
                return null;
            }

            @Override
            public void visitField(FieldNode node) {
                ClassNode declaringClass;
                if (visitor != null) {
                    visitor.visitField(node);
                }
                if ((declaringClass = node.getDeclaringClass()) != null) {
                    rType.set(declaringClass);
                }
            }

            @Override
            public void visitMethod(MethodNode node) {
                ClassNode declaringClass;
                if (visitor != null) {
                    visitor.visitMethod(node);
                }
                if ((declaringClass = node.getDeclaringClass()) != null) {
                    rType.set(declaringClass);
                }
            }

            @Override
            public void visitProperty(PropertyNode node) {
                ClassNode declaringClass;
                if (visitor != null) {
                    visitor.visitProperty(node);
                }
                if ((declaringClass = node.getDeclaringClass()) != null) {
                    rType.set(declaringClass);
                }
            }
        };
        boolean exists = super.existsProperty(pexp, checkForReadOnly, receiverMemoizer);
        if (exists) {
            if (objectExpression.getNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER) == null) {
                objectExpression.putNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER, rType.get());
            }
            if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(objectExpressionType, ClassHelper.LIST_TYPE)) {
                objectExpression.putNodeMetaData((Object)StaticCompilationMetadataKeys.COMPONENT_TYPE, this.inferComponentType(objectExpressionType, ClassHelper.int_TYPE));
            }
        }
        return exists;
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pexp) {
        super.visitPropertyExpression(pexp);
        Object dynamic = pexp.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION);
        if (dynamic != null) {
            pexp.getObjectExpression().putNodeMetaData((Object)StaticCompilationMetadataKeys.RECEIVER_OF_DYNAMIC_PROPERTY, dynamic);
        }
    }

    static {
        ARRAYLIST_ADD_METHOD = ARRAYLIST_CLASSNODE.getMethod("add", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "o")});
        ARRAYLIST_CONSTRUCTOR = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
        ARRAYLIST_CONSTRUCTOR.setDeclaringClass(ARRAYLIST_CLASSNODE);
    }
}

