/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.JGitTestUtil;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalDiskRepositoryTestCase {
    private static Thread shutdownHook;
    private static int testCount;
    private static final boolean useMMAP;
    protected PersonIdent author;
    protected PersonIdent committer;
    private final File trash = new File(new File("target"), "trash");
    private final List<Repository> toClose = new ArrayList<Repository>();
    private MockSystemReader mockSystemReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        LocalDiskRepositoryTestCase localDiskRepositoryTestCase = this;
        synchronized (localDiskRepositoryTestCase) {
            if (shutdownHook == null) {
                shutdownHook = new Thread(){

                    public void run() {
                        System.gc();
                        LocalDiskRepositoryTestCase.recursiveDelete("SHUTDOWN", LocalDiskRepositoryTestCase.this.trash, false, false);
                    }
                };
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
        }
        LocalDiskRepositoryTestCase.recursiveDelete(this.testId(), this.trash, true, false);
        this.mockSystemReader = new MockSystemReader();
        this.mockSystemReader.userGitConfig = new FileBasedConfig(new File(this.trash, "usergitconfig"), FS.DETECTED);
        this.ceilTestDirectories(this.getCeilings());
        SystemReader.setInstance((SystemReader)this.mockSystemReader);
        long now = this.mockSystemReader.getCurrentTime();
        int tz = this.mockSystemReader.getTimezone(now);
        this.author = new PersonIdent("J. Author", "jauthor@example.com");
        this.author = new PersonIdent(this.author, now, tz);
        this.committer = new PersonIdent("J. Committer", "jcommitter@example.com");
        this.committer = new PersonIdent(this.committer, now, tz);
        WindowCacheConfig c = new WindowCacheConfig();
        c.setPackedGitLimit(131072L);
        c.setPackedGitWindowSize(8192);
        c.setPackedGitMMAP(useMMAP);
        c.setDeltaBaseCacheLimit(8192);
        c.install();
    }

    protected List<File> getCeilings() {
        return Collections.singletonList(this.trash.getParentFile().getAbsoluteFile());
    }

    private void ceilTestDirectories(List<File> ceilings) {
        this.mockSystemReader.setProperty("GIT_CEILING_DIRECTORIES", LocalDiskRepositoryTestCase.makePath(ceilings));
    }

    private static String makePath(List<?> objects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objects) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(object.toString());
        }
        return stringBuilder.toString();
    }

    @After
    public void tearDown() throws Exception {
        RepositoryCache.clear();
        for (Repository r : this.toClose) {
            r.close();
        }
        this.toClose.clear();
        if (useMMAP) {
            System.gc();
        }
        LocalDiskRepositoryTestCase.recursiveDelete(this.testId(), this.trash, false, true);
    }

    protected void tick() {
        long delta = TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS);
        long now = this.author.getWhen().getTime() + delta;
        int tz = this.mockSystemReader.getTimezone(now);
        this.author = new PersonIdent(this.author, now, tz);
        this.committer = new PersonIdent(this.committer, now, tz);
    }

    protected void recursiveDelete(File dir) {
        LocalDiskRepositoryTestCase.recursiveDelete(this.testId(), dir, false, true);
    }

    private static boolean recursiveDelete(String testName, File dir, boolean silent, boolean failOnError) {
        assert (!silent || !failOnError);
        if (!dir.exists()) {
            return silent;
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            for (int k = 0; k < ls.length; ++k) {
                File e = ls[k];
                if (e.isDirectory()) {
                    silent = LocalDiskRepositoryTestCase.recursiveDelete(testName, e, silent, failOnError);
                    continue;
                }
                if (e.delete()) continue;
                if (!silent) {
                    LocalDiskRepositoryTestCase.reportDeleteFailure(testName, failOnError, e);
                }
                silent = !failOnError;
            }
        }
        if (!dir.delete()) {
            if (!silent) {
                LocalDiskRepositoryTestCase.reportDeleteFailure(testName, failOnError, dir);
            }
            silent = !failOnError;
        }
        return silent;
    }

    private static void reportDeleteFailure(String testName, boolean failOnError, File e) {
        String severity = failOnError ? "ERROR" : "WARNING";
        String msg = severity + ": Failed to delete " + e + " in " + testName;
        if (failOnError) {
            Assert.fail((String)msg);
        } else {
            System.err.println(msg);
        }
    }

    protected FileRepository createBareRepository() throws IOException {
        return this.createRepository(true);
    }

    protected FileRepository createWorkRepository() throws IOException {
        return this.createRepository(false);
    }

    private FileRepository createRepository(boolean bare) throws IOException {
        File gitdir = this.createUniqueTestGitDir(bare);
        FileRepository db = new FileRepository(gitdir);
        Assert.assertFalse((boolean)gitdir.exists());
        db.create();
        this.toClose.add((Repository)db);
        return db;
    }

    public void addRepoToClose(Repository r) {
        this.toClose.add(r);
    }

    private static String createUniqueTestFolderPrefix() {
        return "test" + System.currentTimeMillis() + "_" + testCount++;
    }

    protected File createTempDirectory(String name) throws IOException {
        String gitdirName = LocalDiskRepositoryTestCase.createUniqueTestFolderPrefix();
        File parent = new File(this.trash, gitdirName);
        File directory = new File(parent, name);
        FileUtils.mkdirs((File)directory);
        return directory.getCanonicalFile();
    }

    protected File createUniqueTestGitDir(boolean bare) throws IOException {
        String gitdirName = LocalDiskRepositoryTestCase.createUniqueTestFolderPrefix();
        if (!bare) {
            gitdirName = gitdirName + "/";
        }
        gitdirName = gitdirName + ".git";
        File gitdir = new File(this.trash, gitdirName);
        return gitdir.getCanonicalFile();
    }

    protected File createTempFile() throws IOException {
        return new File(this.trash, "tmp-" + UUID.randomUUID()).getCanonicalFile();
    }

    protected int runHook(Repository db, File hook, String ... args) throws IOException, InterruptedException {
        String[] argv = new String[1 + args.length];
        argv[0] = hook.getAbsolutePath();
        System.arraycopy(args, 0, argv, 1, args.length);
        HashMap<String, String> env = LocalDiskRepositoryTestCase.cloneEnv();
        env.put("GIT_DIR", db.getDirectory().getAbsolutePath());
        LocalDiskRepositoryTestCase.putPersonIdent(env, "AUTHOR", this.author);
        LocalDiskRepositoryTestCase.putPersonIdent(env, "COMMITTER", this.committer);
        File cwd = db.getWorkTree();
        Process p = Runtime.getRuntime().exec(argv, LocalDiskRepositoryTestCase.toEnvArray(env), cwd);
        p.getOutputStream().close();
        p.getErrorStream().close();
        p.getInputStream().close();
        return p.waitFor();
    }

    private static void putPersonIdent(Map<String, String> env, String type, PersonIdent who) {
        String ident = who.toExternalString();
        String date = ident.substring(ident.indexOf("> ") + 2);
        env.put("GIT_" + type + "_NAME", who.getName());
        env.put("GIT_" + type + "_EMAIL", who.getEmailAddress());
        env.put("GIT_" + type + "_DATE", date);
    }

    protected File write(String body) throws IOException {
        File f = File.createTempFile("temp", "txt", this.trash);
        try {
            this.write(f, body);
            return f;
        }
        catch (Error e) {
            f.delete();
            throw e;
        }
        catch (RuntimeException e) {
            f.delete();
            throw e;
        }
        catch (IOException e) {
            f.delete();
            throw e;
        }
    }

    protected void write(File f, String body) throws IOException {
        JGitTestUtil.write(f, body);
    }

    protected String read(File f) throws IOException {
        return JGitTestUtil.read(f);
    }

    private static String[] toEnvArray(Map<String, String> env) {
        String[] envp = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            envp[i++] = e.getKey() + "=" + e.getValue();
        }
        return envp;
    }

    private static HashMap<String, String> cloneEnv() {
        return new HashMap<String, String>(System.getenv());
    }

    private String testId() {
        return this.getClass().getName() + "." + testCount;
    }

    static {
        useMMAP = "true".equals(System.getProperty("jgit.junit.usemmap"));
    }
}

