/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.wpad.dhcp;

import com.btr.proxy.search.wpad.dhcp.DHCPMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DHCPSocket
extends DatagramSocket {
    private int SOCKET_TIMEOUT = 1000;
    private int mtu = 1500;

    public DHCPSocket(int inPort) throws SocketException {
        super(inPort);
        this.setSoTimeout(this.SOCKET_TIMEOUT);
    }

    public void setMTU(int inSize) {
        this.mtu = inSize;
    }

    public int getMTU() {
        return this.mtu;
    }

    public synchronized void send(DHCPMessage inMessage) throws IOException {
        byte[] data = new byte[this.mtu];
        data = inMessage.externalize();
        InetAddress dest = null;
        try {
            dest = InetAddress.getByName(inMessage.getDestinationAddress());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        DatagramPacket outgoing = new DatagramPacket(data, data.length, dest, inMessage.getPort());
        this.send(outgoing);
    }

    public synchronized boolean receive(DHCPMessage outMessage) {
        try {
            DatagramPacket incoming = new DatagramPacket(new byte[this.mtu], this.mtu);
            this.receive(incoming);
            outMessage.internalize(incoming.getData());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

