/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.instrumentation.PatternInstrumenter;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;

class InstrumentationAdapter
extends FailSafeMethodVisitor
implements Opcodes {
    private static final String RETURN_VALUE_NAME = "$returnvalue$";
    private final Type[] myArgTypes;
    private final Type myReturnType;
    private final int myAccess;
    private final String myMethodName;
    private final PatternInstrumenter myInstrumenter;
    private final List<PatternValue> myParameterPatterns = new ArrayList<PatternValue>();
    private PatternValue myMethodPattern;
    private Label myAssertLabel;

    public InstrumentationAdapter(PatternInstrumenter instrumenter, MethodVisitor methodvisitor, Type[] argTypes, Type returnType, int access, String name) {
        super(327680, methodvisitor);
        this.myInstrumenter = instrumenter;
        this.myArgTypes = argTypes;
        this.myReturnType = returnType;
        this.myAccess = access;
        this.myMethodName = name;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        String annotationClassName;
        AnnotationVisitor annotationvisitor = this.mv.visitParameterAnnotation(parameter, desc, visible);
        if (this.myArgTypes[parameter].getSort() == 10 && this.myInstrumenter.acceptAnnotation(annotationClassName = Type.getType((String)desc).getClassName())) {
            String patternString = this.myInstrumenter.getAnnotationPattern(annotationClassName);
            String[] strings = annotationClassName.split("\\.");
            PatternValue patternValue = new PatternValue(parameter, strings[strings.length - 1], patternString);
            this.myParameterPatterns.add(patternValue);
            return patternString == null ? new MyAnnotationVisitor(annotationvisitor, patternValue) : annotationvisitor;
        }
        return annotationvisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String annotationClassName;
        AnnotationVisitor annotationvisitor = this.mv.visitAnnotation(desc, visible);
        if (this.myReturnType.getSort() == 10 && this.myInstrumenter.acceptAnnotation(annotationClassName = Type.getType((String)desc).getClassName())) {
            String pattern = this.myInstrumenter.getAnnotationPattern(annotationClassName);
            String[] strings = annotationClassName.split("\\.");
            this.myMethodPattern = new PatternValue(-1, strings[strings.length - 1], pattern);
            return pattern == null ? new MyAnnotationVisitor(annotationvisitor, this.myMethodPattern) : annotationvisitor;
        }
        return annotationvisitor;
    }

    public void visitCode() {
        for (PatternValue parameter : this.myParameterPatterns) {
            int j = (this.myAccess & 8) == 0 ? ("<init>".equals(this.myMethodName) ? (this.myInstrumenter.myIsNonStaticInnerClass ? 1 + this.myArgTypes[0].getSize() : 1) : 1) : 0;
            for (int l = 0; l < parameter.index; ++l) {
                j += this.myArgTypes[l].getSize();
            }
            Label checked = new Label();
            this.addPatternTest(parameter.patternIndex, checked, j);
            this.addPatternAssertion(MessageFormat.format("Argument {0} for @{1} parameter of {2}.{3} does not match pattern {4}", parameter.index, parameter.annotation, this.myInstrumenter.myClassName, this.myMethodName, parameter.pattern), false);
            this.mv.visitLabel(checked);
        }
        if (this.myMethodPattern != null) {
            this.myAssertLabel = new Label();
        }
    }

    public void visitInsn(int opcode) {
        if (opcode == 176 && this.myAssertLabel != null) {
            this.mv.visitJumpInsn(167, this.myAssertLabel);
        } else {
            this.mv.visitInsn(opcode);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        try {
            if (this.myAssertLabel != null) {
                int var = maxLocals + 1;
                this.mv.visitLabel(this.myAssertLabel);
                this.mv.visitVarInsn(58, var);
                Label end = new Label();
                this.addPatternTest(this.myMethodPattern.patternIndex, end, var);
                this.addPatternAssertion(MessageFormat.format("Return value of method {0}.{1} annotated as @{2} does not match pattern {3}", this.myInstrumenter.myClassName, this.myMethodName, this.myMethodPattern.annotation, this.myMethodPattern.pattern), true);
                this.mv.visitLabel(end);
                this.mv.visitLocalVariable(RETURN_VALUE_NAME, "Ljava/lang/String;", null, this.myAssertLabel, end, var);
                this.mv.visitVarInsn(25, var);
                this.mv.visitInsn(176);
            }
            super.visitMaxs(maxStack, maxLocals);
        }
        catch (Throwable e) {
            this.myInstrumenter.registerError(this.myMethodName, "visitMaxs", e);
        }
    }

    private void addPatternTest(int patternIndex, Label label, int varIndex) {
        if (this.myInstrumenter.myInstrumentationType == InstrumentationType.ASSERT) {
            this.mv.visitFieldInsn(178, this.myInstrumenter.myClassName, "$assertionsDisabled", "Z");
            this.mv.visitJumpInsn(154, label);
        }
        this.mv.visitVarInsn(25, varIndex);
        this.mv.visitJumpInsn(198, label);
        this.mv.visitFieldInsn(178, this.myInstrumenter.myClassName, "$_PATTERN_CACHE_$", "[Ljava/util/regex/Pattern;");
        this.mv.visitIntInsn(16, patternIndex);
        this.mv.visitInsn(50);
        this.mv.visitVarInsn(25, varIndex);
        this.mv.visitMethodInsn(182, "java/util/regex/Pattern", "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", false);
        this.mv.visitMethodInsn(182, "java/util/regex/Matcher", "matches", "()Z", false);
        this.mv.visitJumpInsn(154, label);
    }

    private void addPatternAssertion(String message, boolean isMethod) {
        if (this.myInstrumenter.myInstrumentationType == InstrumentationType.ASSERT) {
            this.addThrow("java/lang/AssertionError", "(Ljava/lang/Object;)V", message);
        } else if (this.myInstrumenter.myInstrumentationType == InstrumentationType.EXCEPTION) {
            if (isMethod) {
                this.addThrow("java/lang/IllegalStateException", "(Ljava/lang/String;)V", message);
            } else {
                this.addThrow("java/lang/IllegalArgumentException", "(Ljava/lang/String;)V", message);
            }
        }
        this.myInstrumenter.markInstrumented();
    }

    private void addThrow(String throwableClass, String ctorSignature, String message) {
        this.mv.visitTypeInsn(187, throwableClass);
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn((Object)message);
        this.mv.visitMethodInsn(183, throwableClass, "<init>", ctorSignature, false);
        this.mv.visitInsn(191);
    }

    class PatternValue {
        final int index;
        final String annotation;
        String pattern;
        int patternIndex;

        PatternValue(int index, String annotation, String pattern) {
            this.index = index;
            this.annotation = annotation;
            if (pattern != null) {
                this.set(pattern);
            }
        }

        void set(String s) {
            assert (this.pattern == null);
            this.pattern = s;
            this.patternIndex = InstrumentationAdapter.this.myInstrumenter.addPattern(this.pattern);
        }
    }

    private static class MyAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationVisitor av;
        private final PatternValue myPatternValue;

        public MyAnnotationVisitor(AnnotationVisitor annotationvisitor, PatternValue v) {
            super(327680);
            this.av = annotationvisitor;
            this.myPatternValue = v;
        }

        public void visit(String name, Object value) {
            this.av.visit(name, value);
            if ("value".equals(name) && value instanceof String) {
                this.myPatternValue.set((String)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            this.av.visitEnum(name, desc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this.av.visitAnnotation(name, desc);
        }

        public AnnotationVisitor visitArray(String name) {
            return this.av.visitArray(name);
        }

        public void visitEnd() {
            this.av.visitEnd();
        }
    }
}

