/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ext;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.connections.ConnectionOnProcess;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.cvsSupport2.javacvsImpl.io.InputStreamWrapper;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ICvsCommandStopper;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class ExtConnection
extends ConnectionOnProcess {
    public static final String DEFAULT_RSH = "ssh";
    private final String myHost;
    private final String myUserName;
    private final ExtConfiguration myConfiguration;

    public ExtConnection(String host, String user, String repository, ExtConfiguration configuration, ErrorRegistry errorRegistry) {
        super(repository, errorRegistry);
        this.myHost = host;
        this.myUserName = user;
        this.myConfiguration = configuration;
    }

    @Override
    public void open() throws AuthenticationException {
        try {
            this.open(new String[]{"cvs", "server"}, null, null);
        }
        catch (IOException e) {
            throw new AuthenticationException(CvsBundle.message("error.message.cannot.establish.external.connection", new Object[0]), (Throwable)e);
        }
    }

    private void open(String[] commands, String expectedResult, ICvsCommandStopper stopper) throws AuthenticationException, IOException {
        if (this.isOpen()) {
            throw new RuntimeException(CvsBundle.message("error.message.connection.already.open", new Object[0]));
        }
        GeneralCommandLine command = ExtConnection.createRshCommand(this.myHost, this.myUserName, this.myConfiguration);
        command.addParameters(commands);
        this.execute(command);
        if (expectedResult != null) {
            this.check(stopper, expectedResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(ICvsCommandStopper stopper, String expectedResult) throws IOException, AuthenticationException {
        InputStreamWrapper streamWrapper = new InputStreamWrapper(this.myInputStream, stopper, new ReadWriteStatistics());
        try {
            int i;
            StringBuilder buffer = new StringBuilder();
            while ((i = streamWrapper.read()) != -1 && i != 10 && i != 32 && i != 13) {
                buffer.append((char)i);
            }
            String read = buffer.toString().trim();
            if (!expectedResult.equals(read)) {
                if (StringUtil.startsWithConcatenation((String)read, (String[])new String[]{this.myUserName, "@", this.myHost})) {
                    throw new AuthenticationException(CvsBundle.message("exception.text.ext.server.rejected.access", new Object[0]), null);
                }
                if (this.myErrorText.length() > 0) {
                    throw new AuthenticationException(this.myErrorText.toString(), null);
                }
                throw new AuthenticationException(CvsBundle.message("exception.text.ext.cannot.establish.external.connection", new Object[0]), null);
            }
        }
        finally {
            streamWrapper.close();
        }
    }

    private static GeneralCommandLine createRshCommand(String host, String userName, ExtConfiguration config) {
        GeneralCommandLine command = new GeneralCommandLine();
        command.setExePath(config.CVS_RSH);
        command.addParameter(host);
        command.addParameter("-l");
        command.addParameter(userName);
        if (!config.PRIVATE_KEY_FILE.isEmpty()) {
            command.addParameter("-i");
            command.addParameter(config.PRIVATE_KEY_FILE);
        }
        if (!config.ADDITIONAL_PARAMETERS.isEmpty()) {
            StringTokenizer parameters = new StringTokenizer(config.ADDITIONAL_PARAMETERS, " ");
            while (parameters.hasMoreTokens()) {
                command.addParameter(parameters.nextToken());
            }
        }
        return command;
    }
}

