/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.cvsSupport2.connections.ssh.SshTypesToUse;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;

public class SshSettings
implements JDOMExternalizable,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.connections.ssh.ui.SshSettings");
    public boolean USE_PPK = false;
    public String PATH_TO_PPK = "";
    public SshTypesToUse SSH_TYPE = SshTypesToUse.ALLOW_BOTH;
    private static final String SSH_TYPE_ATTRIBUTE = "SSH_TYPE";

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        String sshType = element.getAttributeValue(SSH_TYPE_ATTRIBUTE);
        this.SSH_TYPE = SshTypesToUse.fromName(sshType);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        element.setAttribute(SSH_TYPE_ATTRIBUTE, this.SSH_TYPE.toString());
    }

    public SshSettings clone() {
        try {
            return (SshSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return new SshSettings();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshSettings that = (SshSettings)o;
        if (!this.SSH_TYPE.equals(that.SSH_TYPE)) {
            return false;
        }
        if (this.USE_PPK != that.USE_PPK) {
            return false;
        }
        if (!this.USE_PPK) {
            return true;
        }
        return this.PATH_TO_PPK.equals(that.PATH_TO_PPK);
    }

    public int hashCode() {
        int result;
        int n = result = this.USE_PPK ? 1 : 0;
        if (this.USE_PPK) {
            result = 31 * result + this.PATH_TO_PPK.hashCode();
        }
        result = 31 * result + this.SSH_TYPE.hashCode();
        return result;
    }
}

