/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.google.gson.Gson;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.gson.GsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.ResponseUtil;
import com.intellij.tasks.redmine.RedmineRepositoryType;
import com.intellij.tasks.redmine.RedmineTask;
import com.intellij.tasks.redmine.model.RedmineIssue;
import com.intellij.tasks.redmine.model.RedmineProject;
import com.intellij.tasks.redmine.model.RedmineResponseWrapper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

@Tag(value="Redmine")
public class RedmineRepository
extends NewBaseRepositoryImpl {
    private static final Gson GSON = GsonUtil.createDefaultBuilder().create();
    private static final Pattern ID_PATTERN = Pattern.compile("\\d+");
    public static final RedmineProject UNSPECIFIED_PROJECT = new RedmineProject(){

        @Override
        public String getName() {
            return "-- from all projects --";
        }

        @Override
        public String getIdentifier() {
            return this.getName();
        }

        @Override
        public int getId() {
            return -1;
        }
    };
    private String myAPIKey = "";
    private RedmineProject myCurrentProject;
    private boolean myAssignedToMe = true;
    private List<RedmineProject> myProjects = null;

    public RedmineRepository() {
    }

    public RedmineRepository(RedmineRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUseHttpAuthentication(true);
    }

    public RedmineRepository(RedmineRepository other) {
        super(other);
        this.setAPIKey(other.myAPIKey);
        this.setCurrentProject(other.getCurrentProject());
        this.setAssignedToMe(other.isAssignedToMe());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof RedmineRepository)) {
            return false;
        }
        RedmineRepository that = (RedmineRepository)((Object)o);
        if (!Comparing.equal((String)this.getAPIKey(), (String)that.getAPIKey())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getCurrentProject(), (Object)that.getCurrentProject())) {
            return false;
        }
        return this.isAssignedToMe() == that.isAssignedToMe();
    }

    public RedmineRepository clone() {
        return new RedmineRepository(this);
    }

    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void test() throws Exception {
                URIBuilder uriBuilder = new URIBuilder(RedmineRepository.this.getRestApiUrl("users", "current.json"));
                if (RedmineRepository.this.isUseApiKeyAuthentication()) {
                    uriBuilder.addParameter("key", RedmineRepository.this.getAPIKey());
                }
                this.myCurrentRequest.setURI(uriBuilder.build());
                HttpClient client = RedmineRepository.this.getHttpClient();
                HttpResponse httpResponse = client.execute((HttpUriRequest)this.myCurrentRequest);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null && statusLine.getStatusCode() == 404) {
                    this.myCurrentRequest = new HttpGet(RedmineRepository.this.getProjectsUrl(0, 1));
                    statusLine = client.execute((HttpUriRequest)this.myCurrentRequest).getStatusLine();
                    if (statusLine != null && statusLine.getStatusCode() == 200) {
                        this.myCurrentRequest = new HttpGet(RedmineRepository.this.getIssuesUrl(0, 1, true));
                        statusLine = client.execute((HttpUriRequest)this.myCurrentRequest).getStatusLine();
                    }
                }
                if (statusLine != null && statusLine.getStatusCode() != 200) {
                    throw RequestFailedException.forStatusCode(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
            }
        };
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        List<RedmineIssue> issues = this.fetchIssues(query, offset, limit, withClosed);
        return (Task[])ContainerUtil.map2Array(issues, RedmineTask.class, (Function)new Function<RedmineIssue, RedmineTask>(){

            public RedmineTask fun(RedmineIssue issue) {
                return new RedmineTask(RedmineRepository.this, issue);
            }
        });
    }

    public List<RedmineIssue> fetchIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        this.ensureProjectsDiscovered();
        HttpClient client = this.getHttpClient();
        HttpGet method = new HttpGet(this.getIssuesUrl(offset, limit, withClosed));
        RedmineResponseWrapper.IssuesWrapper wrapper = (RedmineResponseWrapper.IssuesWrapper)client.execute((HttpUriRequest)method, new ResponseUtil.GsonSingleObjectDeserializer<RedmineResponseWrapper.IssuesWrapper>(GSON, RedmineResponseWrapper.IssuesWrapper.class));
        return wrapper == null ? Collections.emptyList() : wrapper.getIssues();
    }

    private URI getIssuesUrl(int offset, int limit, boolean withClosed) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.getRestApiUrl("issues.json")).addParameter("offset", String.valueOf(offset)).addParameter("limit", String.valueOf(limit)).addParameter("sort", "updated_on:desc").addParameter("status_id", withClosed ? "*" : "open");
        if (this.myAssignedToMe) {
            builder.addParameter("assigned_to_id", "me");
        }
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            builder.addParameter("project_id", String.valueOf(this.myCurrentProject.getId()));
        }
        if (this.isUseApiKeyAuthentication()) {
            builder.addParameter("key", this.myAPIKey);
        }
        return builder.build();
    }

    public List<RedmineProject> fetchProjects() throws Exception {
        RedmineResponseWrapper.ProjectsWrapper wrapper;
        HttpClient client = this.getHttpClient();
        ArrayList<RedmineProject> allProjects = new ArrayList<RedmineProject>();
        int offset = 0;
        do {
            HttpGet method = new HttpGet(this.getProjectsUrl(offset, 50));
            wrapper = (RedmineResponseWrapper.ProjectsWrapper)client.execute((HttpUriRequest)method, new ResponseUtil.GsonSingleObjectDeserializer<RedmineResponseWrapper.ProjectsWrapper>(GSON, RedmineResponseWrapper.ProjectsWrapper.class));
            offset += wrapper.getProjects().size();
            allProjects.addAll(wrapper.getProjects());
        } while (wrapper.getTotalCount() > allProjects.size() || wrapper.getProjects().isEmpty());
        this.myProjects = allProjects;
        return Collections.unmodifiableList(this.myProjects);
    }

    private URI getProjectsUrl(int offset, int limit) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.getRestApiUrl("projects.json"));
        builder.addParameter("offset", String.valueOf(offset));
        builder.addParameter("limit", String.valueOf(limit));
        if (this.isUseApiKeyAuthentication()) {
            builder.addParameter("key", this.myAPIKey);
        }
        return builder.build();
    }

    public Task findTask(String id) throws Exception {
        this.ensureProjectsDiscovered();
        HttpGet method = new HttpGet(this.getRestApiUrl("issues", id + ".json"));
        RedmineResponseWrapper.IssueWrapper wrapper = (RedmineResponseWrapper.IssueWrapper)this.getHttpClient().execute((HttpUriRequest)method, new ResponseUtil.GsonSingleObjectDeserializer<RedmineResponseWrapper.IssueWrapper>(GSON, RedmineResponseWrapper.IssueWrapper.class, true));
        if (wrapper == null) {
            return null;
        }
        return new RedmineTask(this, wrapper.getIssue());
    }

    public String getAPIKey() {
        return this.myAPIKey;
    }

    public void setAPIKey(String APIKey) {
        this.myAPIKey = APIKey;
    }

    public boolean isAssignedToMe() {
        return this.myAssignedToMe;
    }

    public void setAssignedToMe(boolean assignedToMe) {
        this.myAssignedToMe = assignedToMe;
    }

    private boolean isUseApiKeyAuthentication() {
        return !this.isUseHttpAuthentication() && StringUtil.isNotEmpty((String)this.myAPIKey);
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            name = name + "/projects/" + StringUtil.notNullize((String)this.myCurrentProject.getIdentifier(), (String)String.valueOf(this.myCurrentProject.getId()));
        }
        return name;
    }

    public boolean isConfigured() {
        if (!super.isConfigured()) {
            return false;
        }
        if (this.isUseHttpAuthentication()) {
            return StringUtil.isNotEmpty((String)this.myPassword) && StringUtil.isNotEmpty((String)this.myUsername);
        }
        return StringUtil.isNotEmpty((String)this.myAPIKey);
    }

    public String extractId(String taskName) {
        return ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF | 1;
    }

    public RedmineProject getCurrentProject() {
        return this.myCurrentProject;
    }

    public void setCurrentProject(RedmineProject project) {
        this.myCurrentProject = project != null && project.getId() == -1 ? UNSPECIFIED_PROJECT : project;
    }

    public List<RedmineProject> getProjects() {
        try {
            this.ensureProjectsDiscovered();
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.myProjects);
    }

    private void ensureProjectsDiscovered() throws Exception {
        if (this.myProjects == null) {
            this.fetchProjects();
        }
    }

    @Transient
    public void setProjects(List<RedmineProject> projects) {
        this.myProjects = projects;
    }
}

