/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import org.jdom.Element;

public class OpenEditorsContextProvider
extends WorkingContextProvider {
    private final FileEditorManagerImpl myFileEditorManager;
    private final DockManagerImpl myDockManager;

    public OpenEditorsContextProvider(FileEditorManager fileEditorManager, DockManager dockManager) {
        this.myDockManager = (DockManagerImpl)dockManager;
        this.myFileEditorManager = fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
    }

    public String getId() {
        return "editors";
    }

    public String getDescription() {
        return "Open editors and positions";
    }

    public void saveContext(Element element) {
        if (this.myFileEditorManager != null) {
            this.myFileEditorManager.writeExternal(element);
        }
        Element state = this.myDockManager.getState();
        element.addContent(state);
    }

    public void loadContext(Element element) {
        Element dockState;
        if (this.myFileEditorManager != null) {
            this.myFileEditorManager.readExternal(element);
            this.myFileEditorManager.getMainSplitters().openFiles();
        }
        if ((dockState = element.getChild("DockManager")) != null) {
            this.myDockManager.loadState(dockState);
            this.myDockManager.readState();
        }
    }

    public void clearContext() {
        if (this.myFileEditorManager != null) {
            this.myFileEditorManager.closeAllFiles();
            this.myFileEditorManager.getMainSplitters().clear();
        }
        for (DockContainer container : this.myDockManager.getContainers()) {
            if (!(container instanceof DockableEditorTabbedContainer)) continue;
            container.closeAll();
        }
    }
}

