/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.bugzilla.BugzillaRepository;
import icons.TasksIcons;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;

public class BugzillaTask
extends Task {
    private final Hashtable<String, Object> myResponse;
    private final BugzillaRepository myRepository;

    public BugzillaTask(Hashtable<String, Object> xmlRpcResponse, BugzillaRepository repository) {
        this.myResponse = xmlRpcResponse;
        this.myRepository = repository;
    }

    public String getId() {
        return String.valueOf(this.myResponse.get("id"));
    }

    public String getSummary() {
        return (String)this.myResponse.get("summary");
    }

    public String getDescription() {
        return null;
    }

    public Comment[] getComments() {
        return Comment.EMPTY_ARRAY;
    }

    public Icon getIcon() {
        return TasksIcons.Bugzilla;
    }

    public TaskType getType() {
        String severity = (String)this.myResponse.get("severity");
        return severity.equalsIgnoreCase("enhancement") ? TaskType.FEATURE : TaskType.BUG;
    }

    public Date getUpdated() {
        return (Date)this.myResponse.get("last_change_time");
    }

    public Date getCreated() {
        return (Date)this.myResponse.get("creation_time");
    }

    public boolean isClosed() {
        return (Boolean)this.myResponse.get("is_open") == false;
    }

    public boolean isIssue() {
        return true;
    }

    public String getIssueUrl() {
        String repositoryUrl = this.myRepository.getUrl();
        if (repositoryUrl.endsWith("xmlrpc.cgi")) {
            repositoryUrl = repositoryUrl.substring(0, repositoryUrl.length() - "xmlrpc.cgi".length());
        }
        return repositoryUrl + "/show_bug.cgi?id=" + this.getId();
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

