/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class TaskAutoCompletionListProvider
extends TextFieldWithAutoCompletionListProvider<Task> {
    private final Project myProject;

    public TaskAutoCompletionListProvider(Project project) {
        super(null);
        this.myProject = project;
    }

    protected String getQuickDocHotKeyAdvertisementTail(String shortcut) {
        return "task description and comments";
    }

    public List<Task> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        return TaskSearchSupport.getItems(TaskManager.getManager((Project)this.myProject), prefix, cached, parameters.isAutoPopup());
    }

    public void setItems(Collection variants) {
    }

    public LookupElementBuilder createLookupBuilder(Task task) {
        LookupElementBuilder builder = super.createLookupBuilder((Object)task);
        builder = builder.withLookupString(task.getSummary());
        if (task.isClosed()) {
            builder = builder.strikeout();
        }
        return builder;
    }

    protected InsertHandler<LookupElement> createInsertHandler(final Task task) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                Document document = context.getEditor().getDocument();
                String s = ((TaskManagerImpl)TaskManager.getManager((Project)context.getProject())).getChangelistName(task);
                s = StringUtil.convertLineSeparators((String)s);
                document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)s);
                context.getEditor().getCaretModel().moveToOffset(context.getStartOffset() + s.length());
                TaskAutoCompletionListProvider.this.handleInsert(task);
            }
        };
    }

    protected void handleInsert(Task task) {
    }

    protected Icon getIcon(Task task) {
        return task.getIcon();
    }

    protected String getLookupString(Task task) {
        return task.getId();
    }

    protected String getTailText(Task task) {
        return " " + task.getSummary();
    }

    protected String getTypeText(Task task) {
        return null;
    }

    public int compare(Task task1, Task task2) {
        throw new UnsupportedOperationException();
    }
}

