/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.ui;

import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ui.AddScreenshotListener;
import com.google.gct.testing.ui.StrokeBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class AddCompareScreenshotPanel {
    public static final int WIDTH = 140;
    private JLabel imageLabel;
    private JLabel textLabel;
    private JPanel myPanel;
    private final ImageIcon COMPARE_REGULAR;
    private final ImageIcon COMPARE_HOVER;
    private final Color regularColor;
    private final Color hoverColor;
    private final Border regularBorder;
    private final Border hoverBorder;
    List<AddScreenshotListener> listeners;

    public AddCompareScreenshotPanel() {
        this.$$$setupUI$$$();
        this.regularColor = UIUtil.isUnderDarcula() ? Color.gray : Color.lightGray;
        this.hoverColor = UIUtil.isUnderDarcula() ? Color.lightGray : Color.gray;
        this.regularBorder = AddCompareScreenshotPanel.createDashedBorder(this.regularColor, 4.0f, 5.0f, 3.0f, true);
        this.hoverBorder = AddCompareScreenshotPanel.createDashedBorder(this.hoverColor, 4.0f, 5.0f, 3.0f, true);
        this.listeners = new LinkedList<AddScreenshotListener>();
        BufferedImage darkImage = null;
        BufferedImage lightImage = null;
        BufferedImage brightImage = null;
        try {
            darkImage = ImageIO.read(AddCompareScreenshotPanel.class.getResourceAsStream("compare-dark.png"));
            darkImage.flush();
            lightImage = ImageIO.read(AddCompareScreenshotPanel.class.getResourceAsStream("compare-light.png"));
            lightImage.flush();
            brightImage = ImageIO.read(AddCompareScreenshotPanel.class.getResourceAsStream("compare-bright.png"));
            brightImage.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.COMPARE_HOVER = UIUtil.isUnderDarcula() ? new ImageIcon(brightImage) : new ImageIcon(darkImage);
        this.COMPARE_REGULAR = new ImageIcon(lightImage);
        this.textLabel.setForeground(Color.gray);
        this.textLabel.setFont(new Font("Arial", 1, 13));
        this.myPanel.setBorder(this.regularBorder);
        this.imageLabel.setText(null);
        this.imageLabel.setIcon(this.COMPARE_REGULAR);
        this.myPanel.addMouseListener(new MouseListener());
    }

    public void setHeight(int height) {
        Dimension panelSize = new Dimension(140, height);
        this.myPanel.setMinimumSize(panelSize);
        this.myPanel.setPreferredSize(panelSize);
    }

    public void addListener(AddScreenshotListener listener) {
        this.listeners.add(listener);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public static Border createDashedBorder(Paint paint, float thickness, float length, float spacing, boolean rounded) {
        int cap = rounded ? 1 : 2;
        int join = rounded ? 1 : 0;
        float[] array = new float[]{thickness * (length - 1.0f), thickness * (spacing + 1.0f)};
        StrokeBorder border = new StrokeBorder(new BasicStroke(thickness, cap, join, thickness * 2.0f, array, 0.0f), paint);
        return border;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("AddScreenshotPanel");
                frame.setDefaultCloseOperation(3);
                JPanel containerPanel = new JPanel(new FlowLayout());
                containerPanel.add(new AddCompareScreenshotPanel().getPanel());
                frame.add(containerPanel);
                frame.setSize(600, 600);
                frame.setVisible(true);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "Center");
        this.textLabel = jLabel2 = new JLabel();
        jLabel2.setText("Compare");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.imageLabel = jLabel = new JLabel();
        jLabel.setText("Image");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (AddScreenshotListener listener : AddCompareScreenshotPanel.this.listeners) {
                listener.addScreenshot();
            }
            this.mouseExited(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AddCompareScreenshotPanel.this.myPanel.setBackground(null);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AddCompareScreenshotPanel.this.myPanel.setBackground(CloudTestingUtils.makeDarker(AddCompareScreenshotPanel.this.myPanel.getBackground(), 1));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AddCompareScreenshotPanel.this.myPanel.setToolTipText("Compare to another screenshot");
            AddCompareScreenshotPanel.this.imageLabel.setIcon(AddCompareScreenshotPanel.this.COMPARE_HOVER);
            AddCompareScreenshotPanel.this.myPanel.setBorder(AddCompareScreenshotPanel.this.hoverBorder);
            AddCompareScreenshotPanel.this.textLabel.setForeground(AddCompareScreenshotPanel.this.hoverColor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AddCompareScreenshotPanel.this.myPanel.setToolTipText(null);
            AddCompareScreenshotPanel.this.imageLabel.setIcon(AddCompareScreenshotPanel.this.COMPARE_REGULAR);
            AddCompareScreenshotPanel.this.myPanel.setBorder(AddCompareScreenshotPanel.this.regularBorder);
            AddCompareScreenshotPanel.this.textLabel.setForeground(AddCompareScreenshotPanel.this.regularColor);
        }
    }
}

