/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingBaseColumn;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.ProxyFilters;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColoredRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class GoogleCloudTestingColumnResults
extends GoogleCloudTestingBaseColumn
implements Comparator<GoogleCloudTestProxy> {
    public static final String UNDEFINED = SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.results.undefined", (Object[])new Object[0]);

    public GoogleCloudTestingColumnResults() {
        super(SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.results.title", (Object[])new Object[0]));
    }

    public Comparator<GoogleCloudTestProxy> getComparator() {
        return this;
    }

    @Override
    public int compare(GoogleCloudTestProxy proxy1, GoogleCloudTestProxy proxy2) {
        if (proxy1.isSuite()) {
            if (proxy2.isSuite()) {
                return this.compareSuites(proxy1, proxy2);
            }
            return 1;
        }
        if (proxy2.isSuite()) {
            return -1;
        }
        return this.compareTests(proxy1, proxy2);
    }

    private int compareTests(GoogleCloudTestProxy test1, GoogleCloudTestProxy test2) {
        int weight1 = test1.getMagnitudeInfo().getSortWeight();
        int weight2 = test2.getMagnitudeInfo().getSortWeight();
        return this.compareInt(weight1, weight2);
    }

    private int compareSuites(GoogleCloudTestProxy suite1, GoogleCloudTestProxy suite2) {
        int failures2;
        int errors2;
        int errors1 = suite1.getChildren((Filter<? super GoogleCloudTestProxy>)ProxyFilters.FILTER_ERRORS).size();
        int errorsComparison = this.compareInt(errors1, errors2 = suite2.getChildren((Filter<? super GoogleCloudTestProxy>)ProxyFilters.FILTER_ERRORS).size());
        if (errorsComparison != 0) {
            return errorsComparison;
        }
        int failures1 = suite1.getChildren((Filter<? super GoogleCloudTestProxy>)ProxyFilters.FILTER_FAILURES).size();
        int failuresComparison = this.compareInt(failures1, failures2 = suite2.getChildren((Filter<? super GoogleCloudTestProxy>)ProxyFilters.FILTER_FAILURES).size());
        if (failuresComparison != 0) {
            return failuresComparison;
        }
        int passed1 = suite1.getChildren((Filter<? super GoogleCloudTestProxy>)ProxyFilters.FILTER_PASSED).size();
        int passed2 = suite2.getChildren((Filter<? super GoogleCloudTestProxy>)ProxyFilters.FILTER_PASSED).size();
        return this.compareInt(passed1, passed2);
    }

    private int compareInt(int first, int second) {
        if (first < second) {
            return -1;
        }
        if (first > second) {
            return 1;
        }
        return 0;
    }

    public String valueOf(GoogleCloudTestProxy testProxy) {
        return UNDEFINED;
    }

    public TableCellRenderer getRenderer(GoogleCloudTestProxy proxy) {
        return new ResultsCellRenderer(proxy);
    }

    public static class ResultsCellRenderer
    extends ColoredTableCellRenderer
    implements ColoredRenderer {
        private final GoogleCloudTestProxy myProxy;

        public ResultsCellRenderer(GoogleCloudTestProxy proxy) {
            this.myProxy = proxy;
        }

        public void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (this.myProxy.isSuite()) {
                GoogleCloudTestsPresentationUtil.appendSuiteStatusColorPresentation(this.myProxy, this);
            } else {
                GoogleCloudTestsPresentationUtil.appendTestStatusColorPresentation(this.myProxy, this);
            }
        }
    }
}

