/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.testIntegration.TestLocationProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;

public abstract class GoogleCloudTestEventsProcessor
implements Disposable {
    private TransferToEDTQueue<Runnable> myTransferToEDTQueue = new TransferToEDTQueue("SM queue", (Processor)new Processor<Runnable>(){

        public boolean process(Runnable runnable) {
            runnable.run();
            return true;
        }
    }, this.getDisposedCondition(), 300);

    public abstract void onStartTesting();

    public abstract void onTestsCountInSuite(int var1);

    public abstract void onTestStarted(GoogleCloudTestStartedEvent var1);

    public abstract void onTestFinished(GoogleCloudTestFinishedEvent var1);

    public abstract void onTestFailure(GoogleCloudTestFailedEvent var1);

    public abstract void onTestIgnored(GoogleCloudTestIgnoredEvent var1);

    public abstract void onTestOutput(GoogleCloudTestOutputEvent var1);

    public abstract void onSuiteStarted(TestSuiteStartedEvent var1);

    public abstract void onSuiteFinished(TestSuiteFinishedEvent var1);

    public abstract void onSetTestRunId(SetTestRunIdEvent var1);

    public abstract void onSetActiveCloudMatrix(SetActiveCloudMatrixEvent var1);

    public abstract void onConfigurationStopped(TestConfigurationStoppedEvent var1);

    public abstract void onConfigurationStarted(TestConfigurationStartedEvent var1);

    public abstract void onConfigurationProgress(TestConfigurationProgressEvent var1);

    public abstract void onConfigurationScheduled(TestConfigurationScheduledEvent var1);

    public abstract void onConfigurationFinished(TestConfigurationFinishedEvent var1);

    public abstract void onUncapturedOutput(String var1, Key var2);

    public abstract void onError(String var1, String var2, boolean var3);

    public abstract void onCustomProgressTestsCategory(String var1, int var2);

    public abstract void onCustomProgressTestStarted();

    public abstract void onCustomProgressTestFailed();

    public abstract void onTestsReporterAttached();

    public abstract void setLocator(TestLocationProvider var1);

    public abstract void addEventsListener(GoogleCloudTestEventsListener var1);

    public abstract void onFinishTesting();

    public abstract void setPrinterProvider(TestProxyPrinterProvider var1);

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GoogleCloudTestEventsProcessor.this.myTransferToEDTQueue.drain();
                }
            });
        }
    }

    public Condition getDisposedCondition() {
        return Condition.FALSE;
    }

    public void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            this.myTransferToEDTQueue.offer((Object)runnable);
        }
    }
}

