/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.launcher.CloudAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public final class CloudTargetUtil {
    private CloudTargetUtil() {
    }

    public static List<ValidationError> validate(AndroidFacet facet, CloudConfiguration.Kind kind, String cloudProjectId, int cloudConfigurationId) {
        ArrayList errors = Lists.newArrayList();
        if (!CloudAuthenticator.isUserLoggedIn()) {
            errors.add(ValidationError.fatal((String)"Not connected to Google Cloud Platform."));
            return errors;
        }
        if (cloudProjectId.isEmpty()) {
            errors.add(ValidationError.fatal((String)"Cloud project not specified."));
        }
        CloudConfiguration selectedConfig = null;
        for (CloudConfiguration cloudConfiguration : CloudConfigurationHelper.getCloudConfigurations(facet, kind)) {
            if (cloudConfiguration.getId() != cloudConfigurationId) continue;
            selectedConfig = cloudConfiguration;
        }
        if (selectedConfig == null) {
            errors.add(ValidationError.fatal((String)"Cloud configuration not specified."));
            return errors;
        }
        if (selectedConfig.getDeviceConfigurationCount() < 1) {
            errors.add(ValidationError.fatal((String)"Selected cloud configuration is empty."));
        }
        return errors;
    }
}

