/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.gct.testing.android.CloudDebuggingTargetConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class CloudDebuggingTarget
extends DeployTarget {
    public static final String ID = "CLOUD_DEVICE_DEBUGGING";
    private String myCloudDeviceSerialNumber;

    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return "Cloud Test Lab Debugging Device";
    }

    public DeployTargetState createState() {
        return new State();
    }

    public DeviceTarget getTarget(DeployTargetState state, AndroidFacet facet, DeviceCount deviceCount, boolean debug, int runConfigId, ConsolePrinter printer) {
        return DeviceTarget.forDevices((Iterable)DeviceSelectionUtils.getAllCompatibleDevices((Predicate)new TargetDeviceFilter(){

            public boolean matchesDevice(IDevice device) {
                if (device.isEmulator()) {
                    return false;
                }
                return device.getSerialNumber().equals(CloudDebuggingTarget.this.myCloudDeviceSerialNumber);
            }
        }));
    }

    public DeployTargetConfigurable createConfigurable(Project project, Disposable parentDisposable, DeployTargetConfigurableContext context) {
        return new CloudDebuggingTargetConfigurable();
    }

    public boolean isApplicable(boolean isTestConfig) {
        return false;
    }

    public void setCloudDeviceSerialNumber(String cloudDeviceSerialNumber) {
        this.myCloudDeviceSerialNumber = cloudDeviceSerialNumber;
    }

    public static final class State
    extends DeployTargetState {
        public List<ValidationError> validate(AndroidFacet facet) {
            return Lists.newArrayList();
        }
    }
}

