/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.spock;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.testIntegration.GroovyTestFramework;

public class SpockTestFramework
extends GroovyTestFramework {
    @Override
    public String getName() {
        return "Spock";
    }

    @Override
    public String getLibraryPath() {
        return null;
    }

    @Override
    public String getDefaultSuperClass() {
        return "spock.lang.Specification";
    }

    @Override
    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock_SetUp_Method.groovy");
    }

    @Override
    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock cleanup Method.groovy");
    }

    @Override
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock Test Method.groovy");
    }

    @Override
    public boolean isTestMethod(PsiElement element) {
        if (!(element instanceof GrMethod)) {
            return false;
        }
        return GroovyPsiManager.isInheritorCached(((GrMethod)element).getContainingClass(), "spock.lang.Specification") && JUnitUtil.getTestMethod((PsiElement)element) != null;
    }

    @Override
    protected String getMarkerClassFQName() {
        return "spock.lang.Specification";
    }

    @Override
    protected boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        return clazz.getLanguage() == GroovyLanguage.INSTANCE && GroovyPsiManager.isInheritorCached(clazz, "spock.lang.Specification");
    }

    private PsiMethod findSpecificMethod(PsiClass clazz, String methodName) {
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.findMethodsByName(methodName, false)) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return method;
        }
        return null;
    }

    @Override
    protected PsiMethod findSetUpMethod(PsiClass clazz) {
        return this.findSpecificMethod(clazz, "setup");
    }

    @Override
    protected PsiMethod findTearDownMethod(PsiClass clazz) {
        return this.findSpecificMethod(clazz, "cleanup");
    }

    @Override
    public char getMnemonic() {
        return 'S';
    }
}

