/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.psi.PsiFile;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GroovyScriptUtil {
    public static final GroovyRunnableScriptType DEFAULT_TYPE = new GroovyRunnableScriptType("default"){

        @Override
        public boolean shouldBeCompiled(GroovyFile script) {
            return true;
        }

        @Override
        public Icon getScriptIcon() {
            return JetgroovyIcons.Groovy.Groovy_16x16;
        }

        @Override
        public GroovyScriptRunner getRunner() {
            return new DefaultGroovyScriptRunner();
        }
    };

    public static boolean isSpecificScriptFile(PsiFile file, GroovyScriptType scriptType) {
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!((GroovyFile)file).isScript()) {
            return false;
        }
        return GroovyScriptUtil.isSpecificScriptFile((GroovyFile)file, scriptType);
    }

    public static boolean isSpecificScriptFile(GroovyFile script, GroovyScriptType scriptType) {
        assert (script.isScript());
        if (scriptType == DEFAULT_TYPE) {
            return GroovyScriptUtil.getScriptType(script) == DEFAULT_TYPE;
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (detector.getScriptType() != scriptType || !detector.isSpecificScriptFile(script)) continue;
            return true;
        }
        return false;
    }

    public static GroovyRunnableScriptType getScriptType(GroovyFile script) {
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            return (GroovyRunnableScriptType)detector.getScriptType();
        }
        return DEFAULT_TYPE;
    }
}

