/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class GrFieldNameSuggester {
    private final GrIntroduceContext myContext;
    private final NameValidator myValidator;
    private final boolean myForStatic;

    public GrFieldNameSuggester(GrIntroduceContext context, NameValidator validator, boolean forStatic) {
        this.myContext = context;
        this.myValidator = validator;
        this.myForStatic = forStatic;
    }

    public LinkedHashSet<String> suggestNames() {
        GrExpression expression = this.myContext.getExpression();
        GrVariable var = this.myContext.getVar();
        StringPartInfo stringPart = this.myContext.getStringPart();
        if (expression != null) {
            return new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNames(expression, this.myValidator, this.myForStatic)));
        }
        if (stringPart != null) {
            return new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNames(stringPart.getLiteral(), this.myValidator, this.myForStatic)));
        }
        assert (var != null);
        return new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNameByType(var.getType(), this.myValidator)));
    }
}

