/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public abstract class ExtractInfoHelperBase
implements ExtractInfoHelper {
    protected final ExtractInfoHelper myInitialInfo;
    protected final Map<String, ParameterInfo> myInputNamesMap;

    public ExtractInfoHelperBase(ExtractInfoHelper initialInfo) {
        this.myInitialInfo = initialInfo;
        ParameterInfo[] infos = initialInfo.getParameterInfos();
        this.myInputNamesMap = new HashMap<String, ParameterInfo>(infos.length);
        for (ParameterInfo info : infos) {
            this.myInputNamesMap.put(info.getName(), info);
        }
    }

    @Override
    public Project getProject() {
        return this.myInitialInfo.getProject();
    }

    @Override
    public ParameterInfo[] getParameterInfos() {
        Collection<ParameterInfo> collection = this.myInputNamesMap.values();
        ParameterInfo[] infos = new ParameterInfo[collection.size()];
        for (ParameterInfo info : collection) {
            int position = info.getPosition();
            assert (position < infos.length && infos[position] == null);
            infos[position] = info;
        }
        return infos;
    }

    @Override
    public VariableInfo[] getOutputVariableInfos() {
        return this.myInitialInfo.getOutputVariableInfos();
    }

    @Override
    public String[] getArgumentNames() {
        Collection<ParameterInfo> infos = this.myInputNamesMap.values();
        String[] argNames = new String[infos.size()];
        for (ParameterInfo info : infos) {
            int position = info.getPosition();
            assert (position < argNames.length);
            argNames[position] = info.passAsParameter() ? info.getOldName() : "";
        }
        return argNames;
    }

    @Override
    public PsiType getOutputType() {
        return this.myInitialInfo.getOutputType();
    }

    @Override
    public PsiElement[] getInnerElements() {
        return this.myInitialInfo.getInnerElements();
    }

    @Override
    public GrStatement[] getStatements() {
        return this.myInitialInfo.getStatements();
    }

    @Override
    public StringPartInfo getStringPartInfo() {
        return this.myInitialInfo.getStringPartInfo();
    }

    @Override
    public GrVariable getVar() {
        return this.myInitialInfo.getVar();
    }

    @Override
    public boolean hasReturnValue() {
        return this.myInitialInfo.hasReturnValue();
    }

    @Override
    public PsiElement getContext() {
        return this.myInitialInfo.getContext();
    }

    @Override
    public boolean isForceReturn() {
        return this.myInitialInfo.isForceReturn();
    }
}

