/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnonymousClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;

public class TypeWriter
extends PsiTypeVisitor<Object> {
    private final boolean acceptEllipsis;
    private final StringBuilder builder;
    private final ClassNameProvider classNameProvider;
    private final PsiElement context;

    public static void writeTypeForNew(StringBuilder builder, PsiType type, PsiElement context) {
        PsiType erased;
        if (type instanceof PsiArrayType && (erased = TypeConversionUtil.erasure((PsiType)type)) != null) {
            type = erased;
        }
        TypeWriter.writeType(builder, type, context, new GeneratorClassNameProvider());
    }

    public static void writeType(StringBuilder builder, PsiType type, PsiElement context) {
        TypeWriter.writeType(builder, type, context, new GeneratorClassNameProvider());
    }

    public static void writeType(StringBuilder builder, PsiType type, PsiElement context, ClassNameProvider classNameProvider) {
        if (type == null || PsiType.NULL.equals((Object)type)) {
            builder.append("java.lang.Object");
            return;
        }
        if (type instanceof PsiPrimitiveType) {
            builder.append(type.getCanonicalText());
            return;
        }
        if (type instanceof GrAnonymousClassType) {
            type = ((GrAnonymousClassType)type).getSimpleClassType();
        }
        boolean acceptEllipsis = TypeWriter.isLastParameter(context);
        type.accept((PsiTypeVisitor)new TypeWriter(builder, classNameProvider, acceptEllipsis, context));
    }

    private TypeWriter(StringBuilder builder, ClassNameProvider classNameProvider, boolean acceptEllipsis, PsiElement context) {
        this.acceptEllipsis = acceptEllipsis;
        this.builder = builder;
        this.classNameProvider = classNameProvider;
        this.context = context;
    }

    public Object visitEllipsisType(PsiEllipsisType ellipsisType) {
        PsiType componentType = ellipsisType.getComponentType();
        componentType.accept((PsiTypeVisitor)this);
        if (this.acceptEllipsis) {
            this.builder.append("...");
        } else {
            this.builder.append("[]");
        }
        return this;
    }

    public Object visitPrimitiveType(PsiPrimitiveType primitiveType) {
        if (this.classNameProvider.forStubs()) {
            this.builder.append(primitiveType.getCanonicalText());
            return this;
        }
        PsiType boxed = TypesUtil.boxPrimitiveType((PsiType)primitiveType, this.context.getManager(), this.context.getResolveScope());
        boxed.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitArrayType(PsiArrayType arrayType) {
        arrayType.getComponentType().accept((PsiTypeVisitor)this);
        this.builder.append("[]");
        return this;
    }

    public Object visitClassType(PsiClassType classType) {
        PsiType[] parameters = classType.getParameters();
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            this.builder.append(classType.getClassName());
        } else {
            String qname = this.classNameProvider.getQualifiedClassName(psiClass, this.context);
            this.builder.append(qname);
        }
        GenerationUtil.writeTypeParameters(this.builder, parameters, this.context, this.classNameProvider);
        return this;
    }

    public Object visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
        capturedWildcardType.getWildcard().accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitWildcardType(PsiWildcardType wildcardType) {
        this.builder.append('?');
        PsiType bound = wildcardType.getBound();
        if (bound == null) {
            return this;
        }
        if (wildcardType.isExtends()) {
            this.builder.append(" extends ");
        } else {
            this.builder.append(" super ");
        }
        bound.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitDisjunctionType(PsiDisjunctionType disjunctionType) {
        throw new UnsupportedOperationException();
    }

    public Object visitType(PsiType type) {
        throw new UnsupportedOperationException();
    }

    private static boolean isLastParameter(PsiElement context) {
        PsiElement scope;
        if (context instanceof PsiParameter && (scope = ((PsiParameter)context).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)scope).getParameterList().getParameters();
            return parameters.length > 0 && parameters[parameters.length - 1] == context;
        }
        return false;
    }
}

