/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeProvider {
    private final Map<GrMethod, PsiType[]> inferredTypes = new HashMap();

    public PsiType getReturnType(PsiMethod method) {
        GrTypeElement typeElement;
        if (method instanceof GrMethod && (typeElement = ((GrMethod)method).getReturnTypeElementGroovy()) != null) {
            return typeElement.getType();
        }
        PsiType smartReturnType = PsiUtil.getSmartReturnType(method);
        if (smartReturnType != null && !PsiType.NULL.equals((Object)smartReturnType)) {
            return smartReturnType;
        }
        if (PsiType.NULL.equals((Object)smartReturnType) && PsiUtil.isVoidMethod(method)) {
            return PsiType.VOID;
        }
        return TypesUtil.getJavaLangObject((PsiElement)method);
    }

    public PsiType getVarType(PsiVariable variable) {
        if (variable instanceof PsiParameter) {
            return this.getParameterType((PsiParameter)variable);
        }
        return TypeProvider.getVariableTypeInner(variable);
    }

    private static PsiType getVariableTypeInner(PsiVariable variable) {
        PsiType type = null;
        if (variable instanceof GrVariable && (type = ((GrVariable)variable).getDeclaredType()) == null) {
            type = ((GrVariable)variable).getTypeGroovy();
        }
        if (type == null) {
            type = variable.getType();
        }
        return type;
    }

    public PsiType getParameterType(PsiParameter parameter) {
        if (!(parameter instanceof GrParameter)) {
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof GrAccessorMethod) {
                return this.getVarType(((GrAccessorMethod)scope).getProperty());
            }
            return parameter.getType();
        }
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof GrParameterList)) {
            return TypeProvider.getVariableTypeInner((PsiVariable)parameter);
        }
        PsiElement pparent = parent.getParent();
        if (!(pparent instanceof GrMethod)) {
            return parameter.getType();
        }
        PsiType[] types = this.inferMethodParameters((GrMethod)pparent);
        return types[((GrParameterList)parent).getParameterNumber((GrParameter)parameter)];
    }

    private PsiType[] inferMethodParameters(GrMethod method) {
        PsiType[] psiTypes = this.inferredTypes.get(method);
        if (psiTypes != null) {
            return psiTypes;
        }
        final GrParameter[] parameters = method.getParameters();
        final TIntArrayList paramInds = new TIntArrayList(parameters.length);
        final PsiType[] types = PsiType.createArray((int)parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getTypeElementGroovy() == null) {
                paramInds.add(i);
                continue;
            }
            types[i] = parameters[i].getType();
        }
        if (!paramInds.isEmpty()) {
            final GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, PsiSubstitutor.EMPTY);
            MethodReferencesSearch.search((PsiMethod)method, (boolean)true).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    PsiElement element = psiReference.getElement();
                    final PsiManager manager = element.getManager();
                    final GlobalSearchScope resolveScope = element.getResolveScope();
                    if (element instanceof GrReferenceExpression) {
                        GrCall call = (GrCall)element.getParent();
                        final GrClosureSignatureUtil.ArgInfo[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call);
                        if (argInfos == null) {
                            return true;
                        }
                        paramInds.forEach(new TIntProcedure(){

                            public boolean execute(int i) {
                                PsiType type = GrClosureSignatureUtil.getTypeByArg(argInfos[i], manager, resolveScope);
                                types[i] = TypesUtil.getLeastUpperBoundNullable(type, types[i], manager);
                                return true;
                            }
                        });
                    }
                    return true;
                }
            });
        }
        paramInds.forEach(new TIntProcedure(){

            public boolean execute(int i) {
                if (types[i] == null || types[i] == PsiType.NULL) {
                    types[i] = parameters[i].getType();
                }
                return true;
            }
        });
        this.inferredTypes.put(method, types);
        return types;
    }

    public PsiType getReturnType(GrClosableBlock closure) {
        PsiType returnType = closure.getReturnType();
        if (PsiType.NULL.equals((Object)returnType) && PsiUtil.isBlockReturnVoid(closure)) {
            return PsiType.VOID;
        }
        if (returnType == null) {
            return TypesUtil.getJavaLangObject(closure);
        }
        return TypesUtil.boxPrimitiveType(returnType, closure.getManager(), closure.getResolveScope());
    }
}

