/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.psi.PsiElement;

public class NodeId {
    private final String myFileUrl;
    private final PsiElement myElement;
    private final String myLocationRootMark;
    private int hash;
    public static final String CONTROLLERS_SUBTREE = "CONTROLLERS_SUBTREE";
    public static final String CONTROLLER_IN_CONTROLLERS_SUBTREE = "CONTROLLER_IN_CONTROLLERS_SUBTREE";
    public static final String ACTION_IN_CONTROLLERS_SUBTREE = "ACTION_IN_CONTROLLERS_SUBTREE";
    public static final String DOMAINS_SUBTREE = "DOMAINS_SUBTREE";
    public static final String DOMAIN_CLASS_IN_DOMAINS_SUBTREE = "DOMAIN_CLASS_IN_DOMAINS_SUBTREE";
    public static final String VIEWS_SUBTREE = "VIEWS_SUBTREE";
    public static final String TESTS_TREE = "TESTS";
    public static final String TEST_CLASS_IN_TESTS_SUBTREE = "TEST_INTESTS";

    public NodeId(String fileUrl, String locationRootMark) {
        this(fileUrl, null, locationRootMark);
    }

    public NodeId(PsiElement element, String locationRootMark) {
        this(null, element, locationRootMark);
    }

    private NodeId(String fileUrl, PsiElement element, String locationRootMark) {
        this.myFileUrl = fileUrl;
        this.myElement = element;
        this.myLocationRootMark = locationRootMark;
    }

    public String getFileUrl() {
        return this.myFileUrl;
    }

    public String getLocationRootMark() {
        return this.myLocationRootMark;
    }

    public PsiElement getPsiElement() {
        return this.myElement;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("[url = ");
        buff.append(this.getFileUrl());
        buff.append(", psiElement = ");
        buff.append(this.getPsiElement());
        buff.append(", location mark = (");
        buff.append(this.getLocationRootMark());
        buff.append(")]");
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        if (this.myFileUrl != null ? !this.myFileUrl.equals(nodeId.myFileUrl) : nodeId.myFileUrl != null) {
            return false;
        }
        if (this.myLocationRootMark != null ? !this.myLocationRootMark.equals(nodeId.myLocationRootMark) : nodeId.myLocationRootMark != null) {
            return false;
        }
        return this.myElement == nodeId.myElement;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.myFileUrl != null ? this.myFileUrl.hashCode() : 1;
            this.hash = 31 * this.hash + (this.myLocationRootMark != null ? this.myLocationRootMark.hashCode() : 0);
            this.hash = this.myElement != null ? 31 * this.hash + this.myElement.hashCode() : 31 * this.hash;
        }
        return this.hash;
    }
}

