/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructure;

public class MvcModuleStructureUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil");
    public static final String PLUGINS_DIRECTORY = "plugins";
    public static final String APPLICATION_PROPERTIES = "application.properties";
    public static final Key<String> LAST_MVC_VERSION = Key.create((String)"LAST_MVC_VERSION");

    private MvcModuleStructureUtil() {
    }

    public static ContentEntry findContentEntry(ModuleRootModel rootModel, VirtualFile root) {
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)root)) continue;
            return entry;
        }
        return null;
    }

    private static Consumer<ModifiableRootModel> addSourceRootsAndLibDirectory(final VirtualFile root, MvcProjectStructure structure) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)structure.myModule);
        HashMap sourceRoots = new HashMap();
        for (ContentEntry entry : moduleRootManager.getContentEntries()) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                sourceRoots.put(folder.getFile(), folder.getRootType());
            }
        }
        root.refresh(false, true);
        final ArrayList actions = ContainerUtil.newArrayList();
        for (Map.Entry entry : structure.getSourceFolders().entrySet()) {
            JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)entry.getKey();
            for (String src : (Collection)entry.getValue()) {
                MvcModuleStructureUtil.addSourceFolder(root, src, rootType, actions, sourceRoots);
            }
        }
        for (String src : structure.getInvalidSourceFolders()) {
            MvcModuleStructureUtil.removeSrcFolderFromRoots(root.findFileByRelativePath(src), (List<Consumer<ContentEntry>>)actions, sourceRoots);
        }
        for (final VirtualFile excluded : structure.getExcludedFolders(root)) {
            if (!moduleRootManager.getFileIndex().isInContent(excluded)) continue;
            actions.add(new Consumer<ContentEntry>(){

                public void consume(ContentEntry contentEntry) {
                    contentEntry.addExcludeFolder(excluded);
                }
            });
        }
        final Consumer<ModifiableRootModel> modifyLib = MvcModuleStructureUtil.addJarDirectory(root, structure.myModule, structure.getUserLibraryName());
        if (actions.isEmpty() && modifyLib == null && MvcModuleStructureUtil.findContentEntry((ModuleRootModel)moduleRootManager, root) != null) {
            return null;
        }
        return new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                ContentEntry contentEntry = MvcModuleStructureUtil.findContentEntry((ModuleRootModel)model, root);
                if (contentEntry == null) {
                    contentEntry = model.addContentEntry(root);
                }
                for (Consumer action : actions) {
                    action.consume((Object)contentEntry);
                }
                if (modifyLib != null) {
                    modifyLib.consume((Object)model);
                }
            }
        };
    }

    public static void removeSrcFolderFromRoots(VirtualFile file, List<Consumer<ContentEntry>> actions, Map<VirtualFile, JpsModuleSourceRootType<?>> sourceRoots) {
        MvcModuleStructureUtil.removeSrcFolderFromRoots(file, actions, sourceRoots.keySet());
    }

    public static void removeSrcFolderFromRoots(final VirtualFile file, List<Consumer<ContentEntry>> actions, Collection<VirtualFile> sourceRoots) {
        if (sourceRoots.contains(file)) {
            actions.add(new Consumer<ContentEntry>(){

                public void consume(ContentEntry contentEntry) {
                    SourceFolder[] folders;
                    for (SourceFolder folder : folders = contentEntry.getSourceFolders()) {
                        if (!Comparing.equal((Object)folder.getFile(), (Object)file)) continue;
                        contentEntry.removeSourceFolder(folder);
                    }
                }
            });
        }
    }

    public static Consumer<ModifiableRootModel> addJarDirectory(VirtualFile root, Module module, final String libName) {
        final VirtualFile libDir = root.findFileByRelativePath("lib");
        if (libDir == null || !libDir.isDirectory() || ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isExcluded(libDir)) {
            return null;
        }
        Library library = MvcModuleStructureUtil.findUserLibrary(module, libName);
        if (library != null && library.isJarDirectory(libDir.getUrl())) {
            return null;
        }
        return new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                Library.ModifiableModel libModel = MvcModuleStructureUtil.modifyDefaultLibrary(model, libName);
                libModel.addJarDirectory(libDir, false);
                libModel.commit();
            }
        };
    }

    public static Library.ModifiableModel modifyDefaultLibrary(ModifiableRootModel model, String libName) {
        LibraryTable libTable = model.getModuleLibraryTable();
        for (Library library : libTable.getLibraries()) {
            if (library.getName() == null || !library.getName().startsWith(libName)) continue;
            return library.getModifiableModel();
        }
        Library library = LibraryUtil.createLibrary((LibraryTable)libTable, (String)(libName + " (" + model.getModule().getName() + ')'));
        for (OrderEntry entry : model.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || libraryEntry.getLibrary() != library) continue;
            libraryEntry.setExported(true);
        }
        return library.getModifiableModel();
    }

    private static void addSourceFolder(VirtualFile root, String relativePath, final JpsModuleSourceRootType<?> rootType, List<Consumer<ContentEntry>> actions, Map<VirtualFile, JpsModuleSourceRootType<?>> sourceRoots) {
        final VirtualFile src = root.findFileByRelativePath(relativePath);
        if (src == null) {
            return;
        }
        JpsModuleSourceRootType<?> existingRootType = sourceRoots.get(src);
        if (rootType == JavaSourceRootType.TEST_SOURCE && existingRootType != null && existingRootType != JavaSourceRootType.TEST_SOURCE) {
            actions.add(new Consumer<ContentEntry>(){

                public void consume(ContentEntry entry) {
                    for (SourceFolder folder : entry.getSourceFolders()) {
                        if (!Comparing.equal((Object)folder.getFile(), (Object)src)) continue;
                        entry.removeSourceFolder(folder);
                        entry.addSourceFolder(src, rootType);
                        break;
                    }
                }
            });
            return;
        }
        actions.add(new Consumer<ContentEntry>(){

            public void consume(ContentEntry contentEntry) {
                contentEntry.addSourceFolder(src, rootType);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateModuleStructure(Module module, MvcProjectStructure structure, VirtualFile root) {
        List<Consumer<ModifiableRootModel>> actions = MvcModuleStructureUtil.getUpdateProjectStructureActions(Collections.singletonList(root), structure);
        if (!actions.isEmpty()) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            boolean success = false;
            try {
                for (Consumer<ModifiableRootModel> action : actions) {
                    action.consume((Object)model);
                }
                model.commit();
                success = true;
            }
            finally {
                if (!success) {
                    model.dispose();
                }
            }
        }
    }

    private static boolean checkValidity(VirtualFile pluginDir) {
        pluginDir.refresh(false, false);
        return pluginDir.isValid();
    }

    private static List<Consumer<ModifiableRootModel>> getUpdateProjectStructureActions(Collection<VirtualFile> appRoots, MvcProjectStructure structure) {
        for (VirtualFile appRoot : ModuleRootManager.getInstance((Module)structure.myModule).getContentRoots()) {
            appRoot.refresh(false, false);
        }
        ArrayList actions = ContainerUtil.newArrayList();
        MvcModuleStructureUtil.removeInvalidSourceRoots(actions, structure);
        MvcModuleStructureUtil.cleanupDefaultLibrary(structure.myModule, actions, appRoots, structure.getUserLibraryName());
        MvcModuleStructureUtil.moveupLibrariesFromMavenPlugin(structure.myModule, actions);
        ArrayList<VirtualFile> rootsToFacetSetup = new ArrayList<VirtualFile>(appRoots.size());
        for (VirtualFile appRoot : appRoots) {
            if (!MvcModuleStructureUtil.checkValidity(appRoot)) continue;
            ContainerUtil.addIfNotNull(MvcModuleStructureUtil.addSourceRootsAndLibDirectory(appRoot, structure), (Collection)actions);
            rootsToFacetSetup.add(appRoot);
        }
        ArrayList<Runnable> facetActions = new ArrayList<Runnable>();
        structure.setupFacets(facetActions, rootsToFacetSetup);
        for (final Runnable action : facetActions) {
            actions.add(new Consumer<ModifiableRootModel>(){

                public void consume(ModifiableRootModel model) {
                    action.run();
                }
            });
        }
        return actions;
    }

    private static OrderEntry[] moveupLibrariesFromMavenPlugin(ModuleRootModel moduleRootModel) {
        LibraryOrderEntry newestLibrary = null;
        int firstLibraryIndex = 0;
        int newestLibraryIndex = 0;
        OrderEntry[] orderEntries = moduleRootModel.getOrderEntries();
        for (int i = 0; i < orderEntries.length; ++i) {
            LibraryOrderEntry libraryEntry;
            String libraryName;
            if (!(orderEntries[i] instanceof LibraryOrderEntry) || (libraryName = (libraryEntry = (LibraryOrderEntry)orderEntries[i]).getLibraryName()) == null || !libraryName.contains("slf4j-api")) continue;
            if (newestLibrary == null) {
                newestLibrary = libraryEntry;
                firstLibraryIndex = i;
                newestLibraryIndex = i;
                continue;
            }
            if (libraryName.compareTo(newestLibrary.getLibraryName()) <= 0) continue;
            newestLibraryIndex = i;
            newestLibrary = libraryEntry;
        }
        if (firstLibraryIndex == newestLibraryIndex) {
            return null;
        }
        Object[] res = (OrderEntry[])orderEntries.clone();
        ArrayUtil.swap((Object[])res, (int)firstLibraryIndex, (int)newestLibraryIndex);
        return res;
    }

    private static void moveupLibrariesFromMavenPlugin(Module module, List<Consumer<ModifiableRootModel>> actions) {
        if (MvcModuleStructureUtil.moveupLibrariesFromMavenPlugin((ModuleRootModel)ModuleRootManager.getInstance((Module)module)) != null) {
            actions.add(new Consumer<ModifiableRootModel>(){

                public void consume(ModifiableRootModel modifiableRootModel) {
                    OrderEntry[] orderEntries = MvcModuleStructureUtil.moveupLibrariesFromMavenPlugin((ModuleRootModel)modifiableRootModel);
                    if (orderEntries != null) {
                        modifiableRootModel.rearrangeOrderEntries(orderEntries);
                    }
                }
            });
        }
    }

    private static void removeInvalidSourceRoots(List<Consumer<ModifiableRootModel>> actions, MvcProjectStructure structure) {
        THashSet toRemove = ContainerUtil.newTroveSet();
        THashSet toRemoveContent = ContainerUtil.newTroveSet();
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)structure.myModule).getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !structure.isValidContentRoot(file)) {
                toRemoveContent.add(entry.getUrl());
                continue;
            }
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (folder.getFile() != null) continue;
                toRemove.add(folder);
            }
        }
        if (!toRemove.isEmpty() || !toRemoveContent.isEmpty()) {
            actions.add(new Consumer<ModifiableRootModel>((Set)toRemoveContent, (Set)toRemove){
                final /* synthetic */ Set val$toRemoveContent;
                final /* synthetic */ Set val$toRemove;
                {
                    this.val$toRemoveContent = set;
                    this.val$toRemove = set2;
                }

                public void consume(ModifiableRootModel model) {
                    for (ContentEntry entry : model.getContentEntries()) {
                        if (this.val$toRemoveContent.remove(entry.getUrl())) {
                            model.removeContentEntry(entry);
                            continue;
                        }
                        for (SourceFolder folder : entry.getSourceFolders()) {
                            if (!this.val$toRemove.remove(folder)) continue;
                            entry.removeSourceFolder(folder);
                        }
                    }
                }
            });
        }
    }

    public static void cleanupDefaultLibrary(Module module, List<Consumer<ModifiableRootModel>> actions, Collection<VirtualFile> appRoots, final String libName) {
        Library library = MvcModuleStructureUtil.findUserLibrary(module, libName);
        if (library == null) {
            return;
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        final ArrayList<String> toRemoveUrls = new ArrayList<String>();
        for (String url : library.getUrls(OrderRootType.CLASSES)) {
            VirtualFile virtualFile = virtualFileManager.findFileByUrl(url);
            if (virtualFile == null) {
                toRemoveUrls.add(url);
                continue;
            }
            if (!library.isJarDirectory(url) || virtualFile.getName().equals("lib") && appRoots.contains(virtualFile.getParent())) continue;
            toRemoveUrls.add(url);
        }
        if (!toRemoveUrls.isEmpty()) {
            actions.add(new Consumer<ModifiableRootModel>(){

                public void consume(ModifiableRootModel model) {
                    Library.ModifiableModel modifiableModel = MvcModuleStructureUtil.modifyDefaultLibrary(model, libName);
                    for (String url : toRemoveUrls) {
                        modifiableModel.removeRoot(url, OrderRootType.CLASSES);
                    }
                    modifiableModel.commit();
                }
            });
        }
    }

    public static boolean hasModulesWithSupport(Project project, MvcFramework framework) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!framework.hasSupport(module)) continue;
            return true;
        }
        return false;
    }

    public static List<Module> getAllModulesWithSupport(Project project, MvcFramework framework) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!framework.hasSupport(module)) continue;
            modules.add(module);
        }
        return modules;
    }

    private static Library extractNonModuleLibraries(List<Library> result, ModuleRootManager rootManager, boolean providedOnly, String userLibraryName) {
        Library userLibrary = null;
        for (OrderEntry entry : rootManager.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
            String libraryName = libraryEntry.getLibraryName();
            if (libraryName != null && libraryName.startsWith(userLibraryName)) {
                userLibrary = library;
                continue;
            }
            if (library.getTable() == null || providedOnly && libraryEntry.getScope().isForProductionRuntime()) continue;
            result.add(library);
        }
        return userLibrary;
    }

    private static Set<String> getJarUrls(Library library) {
        if (library == null) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        for (String url : library.getUrls(OrderRootType.CLASSES)) {
            if (library.isJarDirectory(url)) continue;
            res.add(url);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncAuxModuleSdk(Module appModule, Module pluginsModule, MvcFramework framework) {
        boolean isLibrariesEquals;
        ModuleRootManager auxRootManager = ModuleRootManager.getInstance((Module)pluginsModule);
        ModuleRootManager appRootManager = ModuleRootManager.getInstance((Module)appModule);
        boolean isSdkEquals = Comparing.equal((Object)auxRootManager.getSdk(), (Object)appRootManager.getSdk());
        ArrayList<Library> appLibraries = new ArrayList<Library>();
        Library appUserLibrary = MvcModuleStructureUtil.extractNonModuleLibraries(appLibraries, appRootManager, false, framework.getUserLibraryName());
        ArrayList<Library> auxLibraries = new ArrayList<Library>();
        Library auxUserLibrary = MvcModuleStructureUtil.extractNonModuleLibraries(auxLibraries, auxRootManager, false, framework.getUserLibraryName());
        boolean bl = isLibrariesEquals = ((Object)appLibraries).equals(auxLibraries) && ((Object)MvcModuleStructureUtil.getJarUrls(auxUserLibrary)).equals(MvcModuleStructureUtil.getJarUrls(appUserLibrary));
        if (!isSdkEquals || !isLibrariesEquals) {
            AccessToken token = WriteAction.start();
            try {
                ModifiableRootModel model = auxRootManager.getModifiableModel();
                if (!isSdkEquals) {
                    MvcModuleStructureUtil.copySdk((ModuleRootModel)appRootManager, model);
                }
                if (!isLibrariesEquals) {
                    MvcModuleStructureUtil.copyUserLibraries((ModuleRootModel)appRootManager, model, framework);
                }
                model.commit();
            }
            finally {
                token.finish();
            }
        }
    }

    public static PropertiesFile findApplicationProperties(Module module, MvcFramework framework) {
        VirtualFile root = framework.findAppRoot(module);
        if (root == null) {
            return null;
        }
        VirtualFile appChild = root.findChild(APPLICATION_PROPERTIES);
        if (appChild == null || !appChild.isValid()) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        PsiFile psiFile = manager.findFile(appChild);
        if (psiFile instanceof PropertiesFile) {
            return (PropertiesFile)psiFile;
        }
        return null;
    }

    public static void removeAuxiliaryModule(Module toRemove) {
        SmartList usingModels = new SmartList();
        Project project = toRemove.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        block0: for (Module module : moduleManager.getModules()) {
            if (module == toRemove) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                if (!(entry instanceof ModuleOrderEntry) || toRemove != ((ModuleOrderEntry)entry).getModule()) continue;
                usingModels.add(moduleRootManager.getModifiableModel());
                continue block0;
            }
        }
        ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
        ModuleDeleteProvider.removeModule((Module)toRemove, null, (Collection)usingModels, (ModifiableModuleModel)moduleModel);
        ModifiableRootModel[] rootModels = usingModels.toArray(new ModifiableRootModel[usingModels.size()]);
        ModifiableModelCommitter.multiCommit((ModifiableRootModel[])rootModels, (ModifiableModuleModel)moduleModel);
    }

    public static Module createAuxiliaryModule(Module appModule, String moduleName, MvcFramework framework) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)appModule.getProject());
        ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
        String moduleFilePath = new File(appModule.getModuleFilePath()).getParent() + "/" + moduleName + ".iml";
        VirtualFile existing = LocalFileSystem.getInstance().findFileByPath(moduleFilePath);
        if (existing != null) {
            try {
                existing.delete((Object)"Grails/Griffon plugins maintenance");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        moduleModel.newModule(moduleFilePath, StdModuleTypes.JAVA.getId());
        moduleModel.commit();
        Module pluginsModule = moduleManager.findModuleByName(moduleName);
        assert (pluginsModule != null);
        ModifiableRootModel newRootModel = ModuleRootManager.getInstance((Module)pluginsModule).getModifiableModel();
        ModifiableRootModel appModel = ModuleRootManager.getInstance((Module)appModule).getModifiableModel();
        MvcModuleStructureUtil.copySdkAndLibraries((ModuleRootModel)appModel, newRootModel, framework);
        newRootModel.commit();
        appModel.commit();
        return pluginsModule;
    }

    public static void ensureDependency(Module from, Module to, boolean exported) {
        if (!from.equals(to) && !MvcModuleStructureUtil.hasDependency(from, to)) {
            ModuleRootModificationUtil.addDependency((Module)from, (Module)to, (DependencyScope)DependencyScope.COMPILE, (boolean)exported);
        }
    }

    public static boolean hasDependency(Module from, Module to) {
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)from).getOrderEntries()) {
            ModuleOrderEntry moduleOrderEntry;
            if (!(entry instanceof ModuleOrderEntry) || to != (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) continue;
            return true;
        }
        return false;
    }

    public static void removeDependency(Module from, Module to) {
        if (!from.equals(to) && MvcModuleStructureUtil.hasDependency(from, to)) {
            ModifiableRootModel fromModel = ModuleRootManager.getInstance((Module)from).getModifiableModel();
            for (OrderEntry entry : fromModel.getOrderEntries()) {
                ModuleOrderEntry moduleOrderEntry;
                if (!(entry instanceof ModuleOrderEntry) || to != (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) continue;
                fromModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
            }
            fromModel.commit();
        }
    }

    public static void copySdk(ModuleRootModel from, ModifiableRootModel to) {
        if (from.isSdkInherited()) {
            to.inheritSdk();
        } else {
            to.setSdk(from.getSdk());
        }
    }

    public static void copySdkAndLibraries(ModuleRootModel from, ModifiableRootModel to, MvcFramework framework) {
        MvcModuleStructureUtil.copySdk(from, to);
        MvcModuleStructureUtil.copyUserLibraries(from, to, framework);
    }

    public static void copyUserLibraries(ModuleRootModel from, ModifiableRootModel to, MvcFramework framework) {
        Library userLibraryTo = null;
        for (OrderEntry entry : to.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
            String libraryName = libraryEntry.getLibraryName();
            if (libraryName != null && libraryName.startsWith(framework.getUserLibraryName())) {
                userLibraryTo = library;
                continue;
            }
            if (library.getTable() == null || libraryEntry.getScope().isForProductionRuntime() && !framework.isSDKLibrary(library)) continue;
            to.removeOrderEntry(entry);
        }
        Library userLibraryFrom = null;
        for (OrderEntry entry : from.getOrderEntries()) {
            LibraryOrderEntry libraryEntry;
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
            String libraryName = library.getName();
            if (libraryName != null && libraryName.startsWith(framework.getUserLibraryName())) {
                userLibraryFrom = library;
                continue;
            }
            if (library.getTable() == null) continue;
            LibraryOrderEntry libraryOrderEntry = to.addLibraryEntry(library);
            libraryOrderEntry.setScope(DependencyScope.PROVIDED);
        }
        if (userLibraryTo == null) {
            if (userLibraryFrom == null) {
                return;
            }
            userLibraryTo = to.getModuleLibraryTable().createLibrary(framework.getUserLibraryName() + " (" + to.getModule().getName() + ')');
        } else {
            OrderEntry[] orderEntries = (OrderEntry[])to.getOrderEntries().clone();
            for (int i = 0; i < orderEntries.length; ++i) {
                OrderEntry orderEntry = orderEntries[i];
                if (!(orderEntry instanceof LibraryOrderEntry) || userLibraryTo != ((LibraryOrderEntry)orderEntry).getLibrary()) continue;
                System.arraycopy(orderEntries, i + 1, orderEntries, i, orderEntries.length - i - 1);
                orderEntries[orderEntries.length - 1] = orderEntry;
                to.rearrangeOrderEntries(orderEntries);
                break;
            }
        }
        Library.ModifiableModel model = userLibraryTo.getModifiableModel();
        for (String url : model.getUrls(OrderRootType.CLASSES)) {
            if (model.isJarDirectory(url)) continue;
            model.removeRoot(url, OrderRootType.CLASSES);
        }
        if (userLibraryFrom != null) {
            for (String url : userLibraryFrom.getUrls(OrderRootType.CLASSES)) {
                if (userLibraryFrom.isJarDirectory(url)) continue;
                model.addRoot(url, OrderRootType.CLASSES);
            }
        }
        model.commit();
    }

    public static Consumer<ModifiableRootModel> removeStaleContentEntries(final Collection<VirtualFile> pluginDirs) {
        return new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel modifiableRootModel) {
                for (ContentEntry entry : modifiableRootModel.getContentEntries()) {
                    if (pluginDirs.contains(entry.getFile())) continue;
                    modifiableRootModel.removeContentEntry(entry);
                }
            }
        };
    }

    public static void updateAuxModuleStructure(Module auxModule, Collection<VirtualFile> pluginDirs, MvcFramework framework) {
        MvcProjectStructure structure = framework.createProjectStructure(auxModule, true);
        List<Consumer<ModifiableRootModel>> actions = MvcModuleStructureUtil.getUpdateProjectStructureActions(pluginDirs, structure);
        for (ContentEntry root : ModuleRootManager.getInstance((Module)auxModule).getContentEntries()) {
            if (pluginDirs.contains(root.getFile())) continue;
            actions.add(MvcModuleStructureUtil.removeStaleContentEntries(pluginDirs));
            break;
        }
        if (!actions.isEmpty()) {
            actions.add(MvcModuleStructureUtil.exportDefaultLibrary(structure.getUserLibraryName()));
        }
        if (!actions.isEmpty()) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)auxModule).getModifiableModel();
            for (Consumer<ModifiableRootModel> pluginsUpdateAction : actions) {
                pluginsUpdateAction.consume((Object)model);
            }
            model.commit();
        }
    }

    public static Consumer<ModifiableRootModel> exportDefaultLibrary(final String libraryName) {
        return new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel modifiableRootModel) {
                for (OrderEntry entry : modifiableRootModel.getOrderEntries()) {
                    LibraryOrderEntry libraryOrderEntry;
                    String lName;
                    if (!(entry instanceof LibraryOrderEntry) || (lName = (libraryOrderEntry = (LibraryOrderEntry)entry).getLibraryName()) == null || !lName.startsWith(libraryName)) continue;
                    libraryOrderEntry.setExported(true);
                }
            }
        };
    }

    private static boolean hasChildDirectory(VirtualFile file) {
        for (VirtualFile virtualFile : file.getChildren()) {
            if (!virtualFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static void updateGlobalPluginModule(Project project, MvcFramework framework) {
        MultiMap map = new MultiMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile globalPluginsDir;
            if (!framework.hasSupport(module) || (globalPluginsDir = MvcModuleStructureUtil.refreshAndFind(framework.getGlobalPluginsDir(module))) == null || !MvcModuleStructureUtil.hasChildDirectory(globalPluginsDir)) continue;
            map.putValue((Object)globalPluginsDir, (Object)module);
        }
        HashMap<VirtualFile, Module> globalAuxModules = new HashMap<VirtualFile, Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!framework.isGlobalPluginModule(module)) continue;
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            VirtualFile parent = null;
            if (contentRoots.length > 0) {
                parent = contentRoots[0].getParent();
                if (!map.containsKey((Object)parent)) {
                    parent = null;
                } else {
                    for (int i = 1; i < contentRoots.length; ++i) {
                        if (Comparing.equal((Object)parent, (Object)contentRoots[i].getParent())) continue;
                        parent = null;
                        break;
                    }
                }
            }
            if (parent == null) {
                MvcModuleStructureUtil.removeAuxiliaryModule(module);
                continue;
            }
            globalAuxModules.put(parent, module);
        }
        for (VirtualFile virtualFile : map.keySet()) {
            Module module;
            if (globalAuxModules.containsKey(virtualFile)) continue;
            Module appModule = (Module)map.get((Object)virtualFile).iterator().next();
            module = MvcModuleStructureUtil.createAuxiliaryModule(appModule, MvcModuleStructureUtil.generateUniqueModuleName(project, framework.getGlobalPluginsModuleName()), framework);
            globalAuxModules.put(virtualFile, module);
        }
        assert (map.size() == globalAuxModules.size());
        for (VirtualFile virtualFile : map.keySet()) {
            ArrayList<VirtualFile> pluginRoots = new ArrayList<VirtualFile>();
            for (VirtualFile child : virtualFile.getChildren()) {
                if (!child.isDirectory()) continue;
                pluginRoots.add(child);
            }
            assert (!pluginRoots.isEmpty());
            Module auxModule = (Module)globalAuxModules.get(virtualFile);
            MvcModuleStructureUtil.updateAuxModuleStructure(auxModule, pluginRoots, framework);
            for (Module appModule : map.get((Object)virtualFile)) {
                MvcModuleStructureUtil.ensureDependency(appModule, auxModule, false);
                Module commonPluginsModule = framework.findCommonPluginsModule(appModule);
                if (commonPluginsModule == null) continue;
                MvcModuleStructureUtil.ensureDependency(commonPluginsModule, auxModule, false);
            }
        }
    }

    private static String generateUniqueModuleName(Project project, String prefix) {
        String res;
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        int i = 0;
        do {
            res = i == 0 ? prefix : prefix + i;
            ++i;
        } while (manager.findModuleByName(res) != null);
        return res;
    }

    public static Module updateAuxiliaryPluginsModuleRoots(Module appModule, MvcFramework framework) {
        Module commonPluginsModule = framework.findCommonPluginsModule(appModule);
        HashSet<VirtualFile> pluginRoots = new HashSet<VirtualFile>();
        VirtualFile globalPluginsDir = MvcModuleStructureUtil.refreshAndFind(framework.getGlobalPluginsDir(appModule));
        for (VirtualFile pluginRoot : framework.getCommonPluginRoots(appModule, true)) {
            if (!MvcModuleStructureUtil.checkValidity(pluginRoot) || globalPluginsDir != null && VfsUtil.isAncestor((VirtualFile)globalPluginsDir, (VirtualFile)pluginRoot, (boolean)true)) continue;
            pluginRoots.add(pluginRoot);
        }
        if (pluginRoots.isEmpty()) {
            if (commonPluginsModule != null) {
                MvcModuleStructureUtil.removeAuxiliaryModule(commonPluginsModule);
            }
            return null;
        }
        if (commonPluginsModule == null) {
            commonPluginsModule = MvcModuleStructureUtil.createAuxiliaryModule(appModule, framework.getCommonPluginsModuleName(appModule), framework);
        }
        MvcModuleStructureUtil.ensureDependency(appModule, commonPluginsModule, false);
        MvcModuleStructureUtil.updateAuxModuleStructure(commonPluginsModule, pluginRoots, framework);
        return commonPluginsModule;
    }

    public static Library findUserLibrary(Module module, final String name) {
        CommonProcessors.FindProcessor<Library> processor = new CommonProcessors.FindProcessor<Library>(){

            protected boolean accept(Library library) {
                String libraryName = library.getName();
                return libraryName != null && libraryName.startsWith(name);
            }
        };
        OrderEnumerator.orderEntries((Module)module).forEachLibrary((Processor)processor);
        return (Library)processor.getFoundValue();
    }

    public static VirtualFile refreshAndFind(File file) {
        return MvcModuleStructureUtil.findFile(file, true);
    }

    public static VirtualFile findFile(File file, boolean refresh) {
        if (file == null) {
            return null;
        }
        if (refresh) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        }
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static boolean isEnabledStructureUpdate() {
        return !Boolean.parseBoolean(System.getProperty("grails.disable.structure.update"));
    }
}

