/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCliCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class MvcCommandExecutor {
    private static final ExtensionPointName<MvcCommandExecutor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.mvc.command.executor");

    public static ConsoleProcessDescriptor run(Module module, MvcFramework framework, MvcCommand mvcCommand, Runnable onDone, boolean closeOnDone, String ... input) {
        return MvcCommandExecutor.run(module, framework, mvcCommand, onDone, true, closeOnDone, input);
    }

    public static ConsoleProcessDescriptor run(Module module, MvcFramework framework, MvcCommand mvcCommand, Runnable onDone, boolean showConsole, boolean closeOnDone, String ... input) {
        for (MvcCommandExecutor executor : (MvcCommandExecutor[])EP_NAME.getExtensions()) {
            if (!executor.isApplicable(module)) continue;
            return executor.doRun(module, framework, mvcCommand, onDone, showConsole, closeOnDone, input);
        }
        return new MvcCliCommandExecutor().doRun(module, framework, mvcCommand, onDone, showConsole, closeOnDone, input);
    }

    protected abstract boolean isApplicable(Module var1);

    protected abstract ConsoleProcessDescriptor doRun(Module var1, MvcFramework var2, MvcCommand var3, Runnable var4, boolean var5, boolean var6, String ... var7);
}

