/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class MvcActionBase
extends DumbAwareAction {
    protected abstract void actionPerformed(AnActionEvent var1, Module var2, MvcFramework var3);

    public final void actionPerformed(AnActionEvent e) {
        Pair<MvcFramework, Module> pair = MvcActionBase.guessFramework(e);
        if (pair != null && this.isSupported((MvcFramework)pair.getFirst(), (Module)pair.getSecond())) {
            this.actionPerformed(e, (Module)pair.getSecond(), (MvcFramework)pair.getFirst());
        }
    }

    protected boolean isFrameworkSupported(MvcFramework framework) {
        return true;
    }

    protected boolean isSupported(MvcFramework framework, Module module) {
        return this.isFrameworkSupported(framework);
    }

    public static Pair<MvcFramework, Module> guessFramework(AnActionEvent event) {
        Project project;
        Module module = (Module)event.getData(ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) ? LangDataKeys.MODULE : LangDataKeys.MODULE_CONTEXT);
        if (module != null) {
            MvcFramework framework;
            MvcFramework commonPluginModuleFramework = MvcFramework.findCommonPluginModuleFramework(module);
            if (commonPluginModuleFramework != null) {
                for (Module mod : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                    if (!commonPluginModuleFramework.getCommonPluginsModuleName(mod).equals(module.getName())) continue;
                    if (commonPluginModuleFramework.hasSupport(mod)) {
                        return Pair.create((Object)commonPluginModuleFramework, (Object)mod);
                    }
                    return null;
                }
            }
            if ((framework = MvcFramework.getInstance(module)) != null) {
                return Pair.create((Object)framework, (Object)module);
            }
        }
        if ((project = (Project)DataKeys.PROJECT.getData(event.getDataContext())) == null) {
            return null;
        }
        Pair result = null;
        for (Module mod : ModuleManager.getInstance((Project)project).getModules()) {
            MvcFramework framework = MvcFramework.getInstance(mod);
            if (framework == null) continue;
            if (result != null) {
                return null;
            }
            result = Pair.create((Object)framework, (Object)mod);
        }
        return result;
    }

    public final void update(AnActionEvent event) {
        Pair<MvcFramework, Module> pair = MvcActionBase.guessFramework(event);
        if (pair != null && this.isSupported((MvcFramework)pair.getFirst(), (Module)pair.getSecond())) {
            event.getPresentation().setVisible(true);
            this.updateView(event, (MvcFramework)pair.getFirst(), (Module)pair.getSecond());
        } else {
            event.getPresentation().setVisible(false);
        }
    }

    protected void updateView(AnActionEvent event, MvcFramework framework, Module module) {
    }
}

