/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotationMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GroovyShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public GroovyShortNamesCache(Project project) {
        this.myProject = project;
    }

    public static GroovyShortNamesCache getGroovyShortNamesCache(Project project) {
        return (GroovyShortNamesCache)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.findInstance((Object[])project.getExtensions(PsiShortNamesCache.EP_NAME), GroovyShortNamesCache.class)));
    }

    public PsiClass[] getClassesByName(String name, GlobalSearchScope scope) {
        SmartList allClasses = new SmartList();
        this.processClassesWithName(name, (Processor<? super PsiClass>)new CommonProcessors.CollectProcessor((Collection)allClasses), scope, null);
        if (allClasses.isEmpty()) {
            return PsiClass.EMPTY_ARRAY;
        }
        return allClasses.toArray(new PsiClass[allClasses.size()]);
    }

    public List<PsiClass> getScriptClassesByFQName(String name, GlobalSearchScope scope, boolean srcOnly) {
        Object actualScope = srcOnly ? new GrSourceFilterScope(scope) : scope;
        Collection files = StubIndex.getElements(GrFullScriptNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)actualScope, GroovyFile.class);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (GroovyFile file : files) {
            PsiClass scriptClass;
            if (!file.isScript() || (scriptClass = file.getScriptClass()) == null || !name.equals(scriptClass.getQualifiedName())) continue;
            result.add(scriptClass);
        }
        return result;
    }

    public List<PsiClass> getClassesByFQName(String name, GlobalSearchScope scope) {
        List<PsiClass> result = this.addClasses(name, scope, true);
        if (result.isEmpty()) {
            result.addAll(this.addClasses(name, scope, false));
        }
        if (result.isEmpty()) {
            result.addAll(this.addClasses(name, GlobalSearchScope.projectScope((Project)this.myProject), false));
        }
        return result;
    }

    private List<PsiClass> addClasses(String name, GlobalSearchScope scope, boolean inSource) {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(this.getScriptClassesByFQName(name, scope, inSource));
        for (PsiClass psiClass : StubIndex.getElements(GrFullClassNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)(inSource ? new GrSourceFilterScope(scope) : scope), PsiClass.class)) {
            if (!name.equals(psiClass.getQualifiedName())) continue;
            result.add(psiClass);
        }
        return result;
    }

    public String[] getAllClassNames() {
        return ArrayUtil.toStringArray((Collection)StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
    }

    public void getAllClassNames(HashSet<String> dest) {
        dest.addAll(StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
    }

    public PsiMethod[] getMethodsByName(String name, GlobalSearchScope scope) {
        Collection methods = StubIndex.getElements(GrMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrMethod.class);
        Collection annMethods = StubIndex.getElements(GrAnnotationMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrAnnotationMethod.class);
        if (methods.isEmpty() && annMethods.isEmpty()) {
            return PsiMethod.EMPTY_ARRAY;
        }
        return (PsiMethod[])ArrayUtil.mergeCollections((Collection)annMethods, (Collection)methods, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    public boolean processMethodsWithName(String name, GlobalSearchScope scope, Processor<PsiMethod> processor) {
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(String name, Processor<? super PsiMethod> processor, GlobalSearchScope scope, IdFilter filter) {
        GrSourceFilterScope filterScope = new GrSourceFilterScope(scope);
        return StubIndex.getInstance().processElements(GrMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrMethod.class, processor) && StubIndex.getInstance().processElements(GrAnnotationMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrAnnotationMethod.class, processor);
    }

    public PsiMethod[] getMethodsByNameIfNotMoreThan(String name, GlobalSearchScope scope, int maxCount) {
        return this.getMethodsByName(name, scope);
    }

    public PsiField[] getFieldsByNameIfNotMoreThan(String name, GlobalSearchScope scope, int maxCount) {
        return this.getFieldsByName(name, scope);
    }

    public String[] getAllMethodNames() {
        Collection keys = StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject);
        keys.addAll(StubIndex.getInstance().getAllKeys(GrAnnotationMethodNameIndex.KEY, this.myProject));
        return ArrayUtil.toStringArray((Collection)keys);
    }

    public void getAllMethodNames(HashSet<String> set) {
        set.addAll(StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject));
    }

    public PsiField[] getFieldsByName(String name, GlobalSearchScope scope) {
        Collection fields = StubIndex.getElements(GrFieldNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrField.class);
        if (fields.isEmpty()) {
            return PsiField.EMPTY_ARRAY;
        }
        return fields.toArray(new PsiField[fields.size()]);
    }

    public String[] getAllFieldNames() {
        Collection fields = StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject);
        return ArrayUtil.toStringArray((Collection)fields);
    }

    public void getAllFieldNames(HashSet<String> set) {
        set.addAll(StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject));
    }

    public boolean processFieldsWithName(String name, Processor<? super PsiField> processor, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processElements(GrFieldNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter, GrField.class, processor);
    }

    public boolean processClassesWithName(String name, Processor<? super PsiClass> processor, GlobalSearchScope scope, IdFilter filter) {
        for (GroovyFile file : StubIndex.getElements(GrScriptClassNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), (IdFilter)filter, GroovyFile.class)) {
            PsiClass aClass = file.getScriptClass();
            if (aClass == null || processor.process((Object)aClass)) continue;
            return true;
        }
        return true;
    }
}

