/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import java.util.EnumSet;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class CompletionProcessor
extends ResolverProcessor {
    private CompletionProcessor(PsiElement place, EnumSet<ClassHint.ResolveKind> resolveTargets, String name) {
        super(name, resolveTargets, place, PsiType.EMPTY_ARRAY);
    }

    @Override
    public boolean execute(PsiElement element, ResolveState substitutor) {
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return true;
        }
        super.execute(element, substitutor);
        return true;
    }

    public static ResolverProcessor createPropertyCompletionProcessor(PsiElement place) {
        return new CompletionProcessor(place, RESOLVE_KINDS_METHOD_PROPERTY, null);
    }

    public static ResolverProcessor createRefSameNameProcessor(PsiElement place, String name) {
        return new CompletionProcessor(place, RESOLVE_KINDS_METHOD_PROPERTY, name);
    }

    public static ResolverProcessor createClassCompletionProcessor(PsiElement place) {
        return new CompletionProcessor(place, RESOLVE_KINDS_CLASS_PACKAGE, null);
    }

    @Override
    public GroovyResolveResult[] getCandidates() {
        if (!super.hasCandidates()) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return ResolveUtil.filterSameSignatureCandidates(this.getCandidatesInternal());
    }
}

