/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public class GrScriptField
extends GrLightField {
    public static final GrScriptField[] EMPTY_ARRAY = new GrScriptField[0];

    private GrScriptField(GrVariable original, GroovyScriptClass scriptClass) {
        super(scriptClass, original.getName(), original.getType(), (PsiElement)original);
        GrModifierList modifierList = this.getModifierList();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!original.hasModifierProperty(modifier)) continue;
            ((GrLightModifierList)modifierList).addModifier(modifier);
        }
        for (GrAnnotation annotation : ((GrLightModifierList)modifierList).getAnnotations()) {
            String annotationName;
            String qname = annotation.getQualifiedName();
            String string = annotationName = qname != null ? qname : annotation.getShortName();
            if ("groovy.transform.Field".equals(annotationName)) continue;
            ((GrLightModifierList)modifierList).addAnnotation(annotationName);
        }
    }

    @Override
    public GrAccessorMethod getSetter() {
        return null;
    }

    @Override
    public GrAccessorMethod[] getGetters() {
        return GrAccessorMethod.EMPTY_ARRAY;
    }

    public static GrScriptField getScriptField(final GrVariable original) {
        GroovyScriptClass script = (GroovyScriptClass)((GroovyFile)original.getContainingFile()).getScriptClass();
        assert (script != null);
        GrScriptField result = (GrScriptField)ContainerUtil.find((Object[])GrScriptField.getScriptFields(script), (Condition)new Condition<GrScriptField>(){

            public boolean value(GrScriptField field) {
                return field.getNavigationElement() == original;
            }
        });
        assert (result != null);
        return result;
    }

    public static GrScriptField[] getScriptFields(final GroovyScriptClass script) {
        return (GrScriptField[])CachedValuesManager.getCachedValue((PsiElement)script, (CachedValueProvider)new CachedValueProvider<GrScriptField[]>(){

            public CachedValueProvider.Result<GrScriptField[]> compute() {
                List result = (List)RecursionManager.doPreventingRecursion((Object)((Object)script), (boolean)true, (Computable)new Computable<List<GrScriptField>>(){

                    public List<GrScriptField> compute() {
                        final ArrayList<GrScriptField> result = new ArrayList<GrScriptField>();
                        script.getContainingFile().accept(new GroovyRecursiveElementVisitor(){

                            @Override
                            public void visitVariableDeclaration(GrVariableDeclaration element) {
                                if (element.getModifierList().findAnnotation("groovy.transform.Field") != null) {
                                    for (GrVariable variable : element.getVariables()) {
                                        result.add(new GrScriptField(variable, script));
                                    }
                                }
                                super.visitVariableDeclaration(element);
                            }

                            @Override
                            public void visitMethod(GrMethod method) {
                            }

                            @Override
                            public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
                            }
                        });
                        return result;
                    }
                });
                if (result == null) {
                    return CachedValueProvider.Result.create((Object)EMPTY_ARRAY, (Object[])new Object[]{script.getContainingFile()});
                }
                return CachedValueProvider.Result.create((Object)result.toArray(new GrScriptField[result.size()]), (Object[])new Object[]{script.getContainingFile()});
            }
        });
    }

    public GrVariable getOriginalVariable() {
        return (GrVariable)this.getNavigationElement();
    }
}

