/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class GrBindingVariable
extends GrLightVariable
implements GrVariable {
    private final GroovyFile myFile;
    private Boolean myHasWriteAccess;

    public GrBindingVariable(GroovyFile file, String name, Boolean isWriteAccess) {
        super(file.getManager(), name, "java.lang.Object", (PsiElement)file);
        this.myFile = file;
        this.myHasWriteAccess = isWriteAccess;
    }

    public PsiElement getContext() {
        return this.myFile;
    }

    public Icon getIcon(int flags) {
        return JetgroovyIcons.Groovy.Variable;
    }

    @Override
    public GrExpression getInitializerGroovy() {
        return null;
    }

    @Override
    public void setType(PsiType type) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        return null;
    }

    @Override
    public PsiType getTypeGroovy() {
        return null;
    }

    @Override
    public PsiType getDeclaredType() {
        return null;
    }

    @Override
    public void setInitializerGroovy(GrExpression initializer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement getNameIdentifierGroovy() {
        return GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(this.getName());
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitVariable(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    public boolean hasWriteAccess() {
        if (this.myHasWriteAccess != null) {
            return this.myHasWriteAccess;
        }
        this.myFile.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitAssignmentExpression(GrAssignmentExpression expression) {
                if (GrBindingVariable.this.isRefToMe(expression.getLValue())) {
                    GrBindingVariable.this.myHasWriteAccess = true;
                }
                super.visitAssignmentExpression(expression);
            }

            @Override
            public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
            }

            @Override
            public void visitElement(GroovyPsiElement element) {
                if (GrBindingVariable.this.myHasWriteAccess == null) {
                    super.visitElement(element);
                }
            }
        });
        if (this.myHasWriteAccess == null) {
            this.myHasWriteAccess = false;
        }
        return this.myHasWriteAccess;
    }

    private boolean isRefToMe(PsiElement element) {
        PsiElement resolved;
        return this.maybeRefToMe(element) && ((resolved = ((GrReferenceExpression)element).resolve()) == null || resolved == this);
    }

    private boolean maybeRefToMe(PsiElement element) {
        return element instanceof GrReferenceExpression && !((GrReferenceExpression)element).isQualified() && this.getName().equals(((GrReferenceExpression)element).getReferenceName());
    }

    public void updateWriteAccessIfNeeded(PsiElement place) {
        if (this.myHasWriteAccess == null && this.maybeRefToMe(place)) {
            assert (place != null);
            PsiElement parent = place.getParent();
            if (parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == place) {
                this.myHasWriteAccess = true;
            }
        }
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof GrBindingVariable && StringUtil.equals((CharSequence)this.getName(), (CharSequence)((GrBindingVariable)another).getName()) && this.getManager().areElementsEquivalent((PsiElement)this.getContainingFile(), (PsiElement)another.getContainingFile());
    }

    @Override
    public String toString() {
        return "Binding variable";
    }
}

