/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GrEnumTypeDefinitionImpl
extends GrTypeDefinitionImpl
implements GrEnumTypeDefinition {
    private static final String JAVA_LANG_ENUM = "java.lang.Enum";
    private static final String ENUM_SIMPLE_NAME = "Enum";

    public GrEnumTypeDefinitionImpl(ASTNode node) {
        super(node);
    }

    public GrEnumTypeDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, GroovyElementTypes.ENUM_DEFINITION);
    }

    public String toString() {
        return "Enumeration definition";
    }

    @Override
    public GrEnumDefinitionBody getBody() {
        return (GrEnumDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.ENUM_BODY);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public PsiClassType[] getExtendsListTypes() {
        return new PsiClassType[]{this.createEnumType(), this.createGroovyObjectSupportType()};
    }

    @Override
    protected String[] getExtendsNames() {
        return new String[]{ENUM_SIMPLE_NAME};
    }

    private PsiClassType createEnumType() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass enumClass = facade.findClass(JAVA_LANG_ENUM, this.getResolveScope());
        PsiElementFactory factory = facade.getElementFactory();
        if (enumClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType((PsiClass)this));
            }
            return factory.createType(enumClass, substitutor);
        }
        return TypesUtil.createTypeByFQClassName(JAVA_LANG_ENUM, this);
    }

    private PsiClassType createGroovyObjectSupportType() {
        return TypesUtil.createTypeByFQClassName("groovy.lang.GroovyObjectSupport", this);
    }

    @Override
    public GrField[] getFields() {
        Object[] bodyFields = super.getFields();
        Object[] enumConstants = this.getEnumConstants();
        if (bodyFields.length == 0) {
            return enumConstants;
        }
        if (enumConstants.length == 0) {
            return bodyFields;
        }
        return (GrField[])ArrayUtil.mergeArrays((Object[])bodyFields, (Object[])enumConstants);
    }

    @Override
    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (ResolveUtil.shouldProcessMethods((ClassHint)processor.getHint(ClassHint.KEY))) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint == null ? null : nameHint.getName(state);
            for (PsiMethod method : this.getDefEnumMethods()) {
                if (name != null && !name.equals(method.getName()) || processor.execute((PsiElement)method, state)) continue;
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private PsiMethod[] getDefEnumMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                PsiMethod[] defMethods = new PsiMethod[4];
                PsiManagerEx manager = GrEnumTypeDefinitionImpl.this.getManager();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)GrEnumTypeDefinitionImpl.this.getProject());
                defMethods[0] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "values").setMethodReturnType(factory.createTypeFromText("java.util.Collection<" + GrEnumTypeDefinitionImpl.this.getName() + ">", (PsiElement)GrEnumTypeDefinitionImpl.this)).setContainingClass((PsiClass)GrEnumTypeDefinitionImpl.this).addModifier("public").addModifier("static");
                defMethods[1] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "next").setMethodReturnType((PsiType)factory.createType((PsiClass)GrEnumTypeDefinitionImpl.this)).setContainingClass((PsiClass)GrEnumTypeDefinitionImpl.this).addModifier("public");
                defMethods[2] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "previous").setMethodReturnType((PsiType)factory.createType((PsiClass)GrEnumTypeDefinitionImpl.this)).setContainingClass((PsiClass)GrEnumTypeDefinitionImpl.this).addModifier("public");
                defMethods[3] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "valueOf").setMethodReturnType((PsiType)factory.createType((PsiClass)GrEnumTypeDefinitionImpl.this)).setContainingClass((PsiClass)GrEnumTypeDefinitionImpl.this).addParameter("name", "java.lang.String").addModifier("public").addModifier("static");
                return CachedValueProvider.Result.create((Object)defMethods, (Object[])new Object[]{GrEnumTypeDefinitionImpl.this});
            }
        });
    }

    @Override
    public GrEnumConstant[] getEnumConstants() {
        GrEnumConstantList list = this.getEnumConstantList();
        if (list != null) {
            return list.getEnumConstants();
        }
        return GrEnumConstant.EMPTY_ARRAY;
    }

    @Override
    public GrEnumConstantList getEnumConstantList() {
        GrEnumDefinitionBody enumDefinitionBody = this.getBody();
        if (enumDefinitionBody != null) {
            return enumDefinitionBody.getEnumConstantList();
        }
        return null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitEnumDefinition(this);
    }
}

