/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrWithTraitTypeCalculator
extends GrCallExpressionTypeCalculator {
    @Override
    protected PsiType calculateReturnType(GrMethodCall callExpression, PsiMethod resolvedMethod) {
        GrExpression[] args;
        GrExpression invokedExpression;
        if (!"withTraits".equals(resolvedMethod.getName())) {
            return null;
        }
        if (resolvedMethod instanceof GrGdkMethod) {
            resolvedMethod = ((GrGdkMethod)resolvedMethod).getStaticMethod();
        }
        if (!((invokedExpression = callExpression.getInvokedExpression()) instanceof GrReferenceExpression)) {
            return null;
        }
        GrExpression originalObject = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
        if (originalObject == null) {
            return null;
        }
        PsiType invokedType = originalObject.getType();
        if (!(invokedType instanceof PsiClassType)) {
            return null;
        }
        PsiClass containingClass = resolvedMethod.getContainingClass();
        if (containingClass == null || !"org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName())) {
            return null;
        }
        ArrayList traits = ContainerUtil.newArrayList();
        for (GrExpression arg : args = callExpression.getArgumentList().getExpressionArguments()) {
            PsiType type = arg.getType();
            PsiType classItem = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.lang.Class", (int)0, (boolean)false);
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)classItem);
            if (!GrTraitUtil.isTrait(psiClass)) continue;
            traits.add((PsiClassType)classItem);
        }
        return GrTraitType.createTraitClassType(callExpression, (PsiClassType)invokedType, traits, callExpression.getResolveScope());
    }
}

