/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators;

import com.intellij.psi.PsiType;
import com.intellij.util.NullableFunction;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryFacade;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrNumericBinaryExpressionTypeCalculator
implements NullableFunction<GrBinaryFacade, PsiType> {
    public static final GrNumericBinaryExpressionTypeCalculator INSTANCE = new GrNumericBinaryExpressionTypeCalculator();

    public PsiType fun(GrBinaryFacade e) {
        GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(e.multiResolve(false));
        if (resolveResult.isApplicable() && !PsiUtil.isDGMMethod(resolveResult.getElement())) {
            return ResolveUtil.extractReturnTypeFromCandidate(resolveResult, e.getPsiElement(), new PsiType[]{GrBinaryExpressionUtil.getRightType(e)});
        }
        PsiType lType = GrBinaryExpressionUtil.getLeftType(e);
        PsiType rType = GrBinaryExpressionUtil.getRightType(e);
        if (TypesUtil.isNumericType(lType) && TypesUtil.isNumericType(rType)) {
            assert (lType != null);
            assert (rType != null);
            return this.inferNumericType(lType, rType, e);
        }
        return ResolveUtil.extractReturnTypeFromCandidate(resolveResult, e.getPsiElement(), new PsiType[]{rType});
    }

    protected PsiType inferNumericType(PsiType ltype, PsiType rtype, GrBinaryFacade e) {
        return GrBinaryExpressionUtil.getDefaultNumericResultType(ltype, rtype, e);
    }
}

