/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReassignedLocalVarsChecker {
    public static Boolean isReassignedVar(GrReferenceExpression refExpr) {
        if (!PsiUtil.isCompileStatic(refExpr)) {
            return false;
        }
        if (refExpr.getQualifier() != null) {
            return false;
        }
        final PsiElement resolved = refExpr.resolve();
        if (!PsiUtil.isLocalVariable(resolved)) {
            return false;
        }
        assert (resolved instanceof GrVariable);
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)resolved, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)GrReassignedLocalVarsChecker.isReassignedVarImpl((GrVariable)resolved), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private static boolean isReassignedVarImpl(GrVariable resolved) {
        GrControlFlowOwner variableScope = (GrControlFlowOwner)PsiTreeUtil.getParentOfType((PsiElement)resolved, (Class[])new Class[]{GrCodeBlock.class, GroovyFile.class});
        if (variableScope == null) {
            return false;
        }
        final String name = resolved.getName();
        final Ref isReassigned = Ref.create((Object)false);
        for (PsiElement scope = resolved.getParent().getNextSibling(); scope != null; scope = scope.getNextSibling()) {
            if (!(scope instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)scope).accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitClosure(GrClosableBlock closure) {
                    if (GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(closure).contains(name)) {
                        isReassigned.set((Object)true);
                    }
                }

                @Override
                public void visitElement(GroovyPsiElement element) {
                    if (((Boolean)isReassigned.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }
            });
            if (((Boolean)isReassigned.get()).booleanValue()) break;
        }
        return (Boolean)isReassigned.get();
    }

    public static PsiType getReassignedVarType(GrReferenceExpression refExpr, boolean honorCompileStatic) {
        if (honorCompileStatic && !PsiUtil.isCompileStatic(refExpr) || refExpr.getQualifier() != null) {
            return null;
        }
        PsiElement resolved = refExpr.resolve();
        if (!PsiUtil.isLocalVariable(resolved)) {
            return null;
        }
        assert (resolved instanceof GrVariable);
        return TypeInferenceHelper.getCurrentContext().getExpressionType((GrVariable)resolved, new Function<GrVariable, PsiType>(){

            public PsiType fun(GrVariable variable) {
                return GrReassignedLocalVarsChecker.getLeastUpperBoundByVar(variable);
            }
        });
    }

    private static PsiType getLeastUpperBoundByVar(final GrVariable var) {
        return (PsiType)RecursionManager.doPreventingRecursion((Object)var, (boolean)false, (Computable)new NullableComputable<PsiType>(){

            public PsiType compute() {
                Collection all = ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).findAll();
                GrExpression initializer = var.getInitializerGroovy();
                if (initializer == null && all.isEmpty()) {
                    return var.getDeclaredType();
                }
                PsiType result = initializer != null ? initializer.getType() : null;
                PsiManager manager = var.getManager();
                for (PsiReference reference : all) {
                    PsiElement ref = reference.getElement();
                    if (!(ref instanceof GrReferenceExpression) || !PsiUtil.isLValue((GrReferenceExpression)ref)) continue;
                    result = TypesUtil.getLeastUpperBoundNullable(result, TypeInferenceHelper.getInitializerTypeFor(ref), manager);
                }
                return result;
            }
        });
    }

    private static Set<String> getUsedVarsInsideBlock(final GrCodeBlock block) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)block, (CachedValueProvider)new CachedValueProvider<Set<String>>(){

            public CachedValueProvider.Result<Set<String>> compute() {
                final HashSet result = ContainerUtil.newHashSet();
                block.acceptChildren(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitOpenBlock(GrOpenBlock openBlock) {
                        result.addAll(GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(openBlock));
                    }

                    @Override
                    public void visitClosure(GrClosableBlock closure) {
                        result.addAll(GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(closure));
                    }

                    @Override
                    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                        if (referenceExpression.getQualifier() == null && referenceExpression.getReferenceName() != null) {
                            result.add(referenceExpression.getReferenceName());
                        }
                    }
                });
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{block});
            }
        });
    }
}

