/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.InstanceOfInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeInferenceHelper {
    private static final Logger LOG = Logger.getInstance(TypeInferenceHelper.class);
    private static final ThreadLocal<InferenceContext> ourInferenceContext = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doInference(Map<String, PsiType> bindings, Computable<T> computation) {
        InferenceContext old = ourInferenceContext.get();
        ourInferenceContext.set(new InferenceContext.PartialContext(bindings));
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            ourInferenceContext.set(old);
        }
    }

    public static InferenceContext getCurrentContext() {
        InferenceContext context = ourInferenceContext.get();
        return context != null ? context : InferenceContext.TOP_CONTEXT;
    }

    public static PsiType getInferredType(GrReferenceExpression refExpr) {
        GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(refExpr);
        if (scope == null) {
            return null;
        }
        String referenceName = refExpr.getReferenceName();
        if (referenceName == null) {
            return null;
        }
        ReadWriteVariableInstruction rwInstruction = ControlFlowUtils.findRWInstruction(refExpr, scope.getControlFlow());
        if (rwInstruction == null) {
            return null;
        }
        return TypeInferenceHelper.getInferenceCache(scope).getInferredType(referenceName, rwInstruction);
    }

    public static PsiType getInferredType(PsiElement place, String variableName) {
        GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(place);
        if (scope == null) {
            return null;
        }
        Instruction nearest = ControlFlowUtils.findNearestInstruction(place, scope.getControlFlow());
        if (nearest == null) {
            return null;
        }
        return TypeInferenceHelper.getInferenceCache(scope).getInferredType(variableName, nearest);
    }

    private static InferenceCache getInferenceCache(final GrControlFlowOwner scope) {
        return (InferenceCache)CachedValuesManager.getCachedValue((PsiElement)scope, (CachedValueProvider)new CachedValueProvider<InferenceCache>(){

            public CachedValueProvider.Result<InferenceCache> compute() {
                return CachedValueProvider.Result.create((Object)new InferenceCache(scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    public static boolean isTooComplexTooAnalyze(GrControlFlowOwner scope) {
        return TypeInferenceHelper.getDefUseMaps(scope) == null;
    }

    private static DFAType getInferredType(String varName, Instruction instruction, Instruction[] flow, GrControlFlowOwner scope, Set<MixinTypeInstruction> trace) {
        Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> pair = TypeInferenceHelper.getDefUseMaps(scope);
        if (pair == null) {
            return null;
        }
        int varIndex = ((ReachingDefinitionsDfaInstance)pair.first).getVarIndex(varName);
        DefinitionMap allDefs = (DefinitionMap)((List)pair.second).get(instruction.num());
        int[] varDefs = allDefs.getDefinitions(varIndex);
        if (varDefs == null) {
            return null;
        }
        DFAType result = null;
        for (int defIndex : varDefs) {
            DFAType defType = TypeInferenceHelper.getDefinitionType(flow[defIndex], flow, scope, trace);
            if (defType != null) {
                defType = defType.negate(instruction);
            }
            if (defType == null) continue;
            result = result == null ? defType : DFAType.create(defType, result, scope.getManager());
        }
        return result;
    }

    private static Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> getDefUseMaps(final GrControlFlowOwner scope) {
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)scope, (CachedValueProvider)new CachedValueProvider<Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>>>(){

            public CachedValueProvider.Result<Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>>> compute() {
                ReachingDefinitionsSemilattice lattice;
                ReachingDefinitionsDfaInstance dfaInstance;
                final Instruction[] flow = scope.getControlFlow();
                DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance = new ReachingDefinitionsDfaInstance(flow){

                    @Override
                    public void fun(DefinitionMap m, Instruction instruction) {
                        if (instruction instanceof InstanceOfInstruction) {
                            int varIndex;
                            InstanceOfInstruction instanceOfInstruction = (InstanceOfInstruction)instruction;
                            ReadWriteVariableInstruction i = instanceOfInstruction.getInstructionToMixin(flow);
                            if (i != null && (varIndex = this.getVarIndex(i.getVariableName())) >= 0) {
                                m.registerDef(instruction, varIndex);
                            }
                        } else if (instruction instanceof ArgumentInstruction) {
                            String variableName = ((ArgumentInstruction)instruction).getVariableName();
                            if (variableName != null) {
                                m.registerDef(instruction, this.getVarIndex(variableName));
                            }
                        } else {
                            super.fun(m, instruction);
                        }
                    }
                }, lattice = new ReachingDefinitionsSemilattice());
                ArrayList<DefinitionMap> dfaResult = engine.performDFAWithTimeout();
                Pair result = dfaResult == null ? null : Pair.create((Object)dfaInstance, dfaResult);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private static DFAType getDefinitionType(Instruction instruction, Instruction[] flow, GrControlFlowOwner scope, Set<MixinTypeInstruction> trace) {
        PsiElement element;
        if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite() && (element = instruction.getElement()) != null) {
            return DFAType.create(TypesUtil.boxPrimitiveType(TypeInferenceHelper.getInitializerType(element), scope.getManager(), scope.getResolveScope()));
        }
        if (instruction instanceof MixinTypeInstruction) {
            return TypeInferenceHelper.mixinType((MixinTypeInstruction)instruction, flow, scope, trace);
        }
        return null;
    }

    private static DFAType mixinType(MixinTypeInstruction instruction, Instruction[] flow, GrControlFlowOwner scope, Set<MixinTypeInstruction> trace) {
        if (!trace.add(instruction)) {
            return null;
        }
        String varName = instruction.getVariableName();
        if (varName == null) {
            return null;
        }
        ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(flow);
        if (originalInstr == null) {
            LOG.error(scope.getContainingFile().getName() + ":" + scope.getText());
        }
        DFAType original = TypeInferenceHelper.getInferredType(varName, originalInstr, flow, scope, trace);
        PsiType mixin = instruction.inferMixinType();
        if (mixin == null) {
            return original;
        }
        if (original == null) {
            original = DFAType.create(null);
        }
        original.addMixin(mixin, instruction.getConditionInstruction());
        trace.remove(instruction);
        return original;
    }

    public static PsiType getInitializerType(PsiElement element) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifierExpression() == null) {
            return TypeInferenceHelper.getInitializerTypeFor(element);
        }
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        return null;
    }

    public static PsiType getInitializerTypeFor(PsiElement element) {
        GrTupleExpression list;
        PsiElement parent = element.getParent();
        if (parent instanceof GrAssignmentExpression) {
            if (element instanceof GrIndexProperty) {
                GrExpression rvalue = ((GrAssignmentExpression)parent).getRValue();
                return rvalue != null ? rvalue.getType() : null;
            }
            return ((GrAssignmentExpression)parent).getType();
        }
        if (parent instanceof GrTupleExpression && (list = (GrTupleExpression)parent).getParent() instanceof GrAssignmentExpression) {
            GrExpression rValue = ((GrAssignmentExpression)list.getParent()).getRValue();
            int idx = list.indexOf(element);
            if (idx >= 0 && rValue != null) {
                PsiType rType = rValue.getType();
                if (rType instanceof GrTupleType) {
                    PsiType[] componentTypes = ((GrTupleType)rType).getComponentTypes();
                    if (idx < componentTypes.length) {
                        return componentTypes[idx];
                    }
                    return null;
                }
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)rType, (boolean)false);
            }
        }
        if (parent instanceof GrUnaryExpression && TokenSets.POSTFIX_UNARY_OP_SET.contains(((GrUnaryExpression)parent).getOperationTokenType())) {
            return ((GrUnaryExpression)parent).getType();
        }
        return null;
    }

    public static GrExpression getInitializerFor(GrExpression lValue) {
        PsiElement parent = lValue.getParent();
        if (parent instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent).getRValue();
        }
        if (parent instanceof GrTupleExpression) {
            GrExpression[] initializers;
            int i = ((GrTupleExpression)parent).indexOf(lValue);
            PsiElement pparent = parent.getParent();
            PsiUtil.LOG.assertTrue(pparent instanceof GrAssignmentExpression);
            GrExpression rValue = ((GrAssignmentExpression)pparent).getRValue();
            if (rValue instanceof GrListOrMap && !((GrListOrMap)rValue).isMap() && (initializers = ((GrListOrMap)rValue).getInitializers()).length < i) {
                return initializers[i];
            }
        }
        return null;
    }

    private static class InferenceCache {
        final GrControlFlowOwner scope;
        final Instruction[] flow;
        final AtomicReference<List<TypeDfaState>> varTypes;
        final Set<Instruction> tooComplex = ContainerUtil.newConcurrentSet();

        InferenceCache(GrControlFlowOwner scope) {
            this.scope = scope;
            this.flow = scope.getControlFlow();
            ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
            for (int i = 0; i < this.flow.length; ++i) {
                noTypes.add(new TypeDfaState());
            }
            this.varTypes = new AtomicReference(noTypes);
        }

        private PsiType getInferredType(String variableName, Instruction instruction) {
            DFAType dfaType;
            if (this.tooComplex.contains(instruction)) {
                return null;
            }
            TypeDfaState cache = this.varTypes.get().get(instruction.num());
            if (!cache.containsVariable(variableName)) {
                Pair defUse = TypeInferenceHelper.getDefUseMaps(this.scope);
                if (defUse == null) {
                    this.tooComplex.add(instruction);
                    return null;
                }
                Set<Instruction> interesting = this.collectRequiredInstructions(instruction, variableName, (Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>>)defUse);
                List<TypeDfaState> dfaResult = this.performTypeDfa(this.scope, this.flow, interesting);
                if (dfaResult == null) {
                    this.tooComplex.addAll(interesting);
                } else {
                    this.cacheDfaResult(dfaResult);
                }
            }
            return (dfaType = this.getCachedInferredType(variableName, instruction)) == null ? null : dfaType.getResultType();
        }

        private List<TypeDfaState> performTypeDfa(GrControlFlowOwner owner, Instruction[] flow, Set<Instruction> interesting) {
            TypeDfaInstance dfaInstance = new TypeDfaInstance(owner, flow, interesting, this);
            TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
            return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
        }

        DFAType getCachedInferredType(String variableName, Instruction instruction) {
            DFAType dfaType = this.varTypes.get().get(instruction.num()).getVariableType(variableName);
            return dfaType == null ? null : dfaType.negate(instruction);
        }

        private Set<Instruction> collectRequiredInstructions(Instruction instruction, String variableName, Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> defUse) {
            HashSet interesting = ContainerUtil.newHashSet((Object[])new Instruction[]{instruction});
            LinkedList queue = ContainerUtil.newLinkedList();
            queue.add(Pair.create((Object)instruction, (Object)variableName));
            while (!queue.isEmpty()) {
                Pair pair = (Pair)queue.removeFirst();
                for (Pair<Instruction, String> dep : this.findDependencies(defUse, (Instruction)pair.first, (String)pair.second)) {
                    if (!interesting.add(dep.first)) continue;
                    queue.addLast(dep);
                }
            }
            return interesting;
        }

        private Set<Pair<Instruction, String>> findDependencies(Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> defUse, Instruction insn, String varName) {
            int varIndex;
            DefinitionMap definitionMap = (DefinitionMap)((List)defUse.second).get(insn.num());
            int[] definitions = definitionMap.getDefinitions(varIndex = ((ReachingDefinitionsDfaInstance)defUse.first).getVarIndex(varName));
            if (definitions == null) {
                return Collections.emptySet();
            }
            LinkedHashSet pairs = ContainerUtil.newLinkedHashSet();
            for (int defIndex : definitions) {
                Instruction write = this.flow[defIndex];
                pairs.add(Pair.create((Object)write, (Object)varName));
                PsiElement statement = InferenceCache.findDependencyScope(write.getElement());
                if (statement == null) continue;
                pairs.addAll(this.findAllInstructionsInside(statement));
            }
            return pairs;
        }

        private List<Pair<Instruction, String>> findAllInstructionsInside(PsiElement scope) {
            final ArrayList result = ContainerUtil.newArrayList();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    String varName;
                    if (element instanceof GrReferenceExpression && !((GrReferenceExpression)element).isQualified() && (varName = ((GrReferenceExpression)element).getReferenceName()) != null) {
                        for (Instruction dependency : ControlFlowUtils.findAllInstructions(element, InferenceCache.this.flow)) {
                            result.add(Pair.create((Object)dependency, (Object)varName));
                        }
                    }
                    super.visitElement(element);
                }
            });
            return result;
        }

        private static PsiElement findDependencyScope(PsiElement element) {
            return PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new Condition<PsiElement>(){

                public boolean value(PsiElement element) {
                    return PsiUtil.isExpressionStatement(element) || !(element.getParent() instanceof GrExpression);
                }
            });
        }

        private void cacheDfaResult(List<TypeDfaState> dfaResult) {
            List<TypeDfaState> oldTypes;
            while (!this.varTypes.compareAndSet(oldTypes = this.varTypes.get(), InferenceCache.addDfaResult(dfaResult, oldTypes))) {
            }
        }

        private static List<TypeDfaState> addDfaResult(List<TypeDfaState> dfaResult, List<TypeDfaState> oldTypes) {
            ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
            for (int i = 0; i < dfaResult.size(); ++i) {
                newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
            }
            return newTypes;
        }
    }

    static class TypeDfaInstance
    implements DfaInstance<TypeDfaState> {
        private final GrControlFlowOwner myScope;
        private final Instruction[] myFlow;
        private final Set<Instruction> myInteresting;
        private final InferenceCache myCache;

        TypeDfaInstance(GrControlFlowOwner scope, Instruction[] flow, Set<Instruction> interesting, InferenceCache cache) {
            this.myScope = scope;
            this.myFlow = flow;
            this.myInteresting = interesting;
            this.myCache = cache;
        }

        @Override
        public void fun(TypeDfaState state, Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction) {
                this.handleVariableWrite(state, (ReadWriteVariableInstruction)instruction);
            } else if (instruction instanceof MixinTypeInstruction) {
                this.handleMixin(state, (MixinTypeInstruction)instruction);
            }
        }

        private void handleMixin(final TypeDfaState state, final MixinTypeInstruction instruction) {
            final String varName = instruction.getVariableName();
            if (varName == null) {
                return;
            }
            this.updateVariableType(state, instruction, varName, (Computable<DFAType>)new NullableComputable<DFAType>(){

                public DFAType compute() {
                    ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(TypeDfaInstance.this.myFlow);
                    assert (originalInstr != null && !originalInstr.isWrite());
                    DFAType original = state.getVariableType(varName);
                    if (original == null) {
                        original = DFAType.create(null);
                    }
                    original = original.negate(originalInstr);
                    original.addMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
                    return original;
                }
            });
        }

        private void handleVariableWrite(TypeDfaState state, ReadWriteVariableInstruction instruction) {
            final PsiElement element = instruction.getElement();
            if (element != null && instruction.isWrite()) {
                this.updateVariableType(state, instruction, instruction.getVariableName(), new Computable<DFAType>(){

                    public DFAType compute() {
                        return DFAType.create(TypesUtil.boxPrimitiveType(TypeInferenceHelper.getInitializerType(element), TypeDfaInstance.this.myScope.getManager(), TypeDfaInstance.this.myScope.getResolveScope()));
                    }
                });
            }
        }

        private void updateVariableType(TypeDfaState state, Instruction instruction, String variableName, Computable<DFAType> computation) {
            if (!this.myInteresting.contains(instruction)) {
                state.removeBinding(variableName);
                return;
            }
            DFAType type = this.myCache.getCachedInferredType(variableName, instruction);
            if (type == null) {
                type = (DFAType)TypeInferenceHelper.doInference(state.getBindings(instruction), computation);
            }
            state.putType(variableName, type);
        }

        @Override
        public TypeDfaState initial() {
            return new TypeDfaState();
        }

        @Override
        public boolean isForward() {
            return true;
        }
    }
}

