/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.CompoundStringExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class PathExpression {
    private static final TokenSet DOTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mDOT});
    private static final TokenSet PATH_ELEMENT_START = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSPREAD_DOT, GroovyTokenTypes.mOPTIONAL_DOT, GroovyTokenTypes.mMEMBER_POINTER, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mDOT});

    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        return PathExpression.parsePathExprQualifierForExprStatement(builder, parser) != Result.WRONG_WAY;
    }

    public static Result parsePathExprQualifierForExprStatement(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType qualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser);
        if (qualifierType != GroovyElementTypes.WRONGWAY) {
            return PathExpression.parseAfterQualifier(builder, parser, marker, qualifierType);
        }
        marker.drop();
        return Result.WRONG_WAY;
    }

    private static Result parseAfterQualifier(PsiBuilder builder, GroovyParser parser, PsiBuilder.Marker marker, IElementType qualifierType) {
        if (PathExpression.isPathElementStart(builder)) {
            if (PathExpression.isLParenthOrLCurlyAfterLiteral(builder, qualifierType)) {
                marker.rollbackTo();
                PsiBuilder.Marker newMarker = builder.mark();
                IElementType newQualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser, true);
                assert (newQualifierType != GroovyElementTypes.WRONGWAY);
                return PathExpression.parseAfterReference(builder, parser, newMarker);
            }
            return PathExpression.parseAfterReference(builder, parser, marker);
        }
        marker.drop();
        if (qualifierType == GroovyElementTypes.LITERAL) {
            return Result.LITERAL;
        }
        return Result.INVOKED_EXPR;
    }

    private static boolean isLParenthOrLCurlyAfterLiteral(PsiBuilder builder, IElementType qualifierType) {
        return qualifierType == GroovyElementTypes.LITERAL && (PathExpression.checkForLParenth(builder) || PathExpression.checkForLCurly(builder));
    }

    private static Result pathElementParse(PsiBuilder builder, PsiBuilder.Marker marker, GroovyParser parser, Result result) {
        if (DOTS.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mDOT)) {
            if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mDOT)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            }
            ParserUtils.getToken(builder, DOTS);
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            TypeArguments.parseTypeArguments(builder, true);
            GroovyElementType res = PathExpression.namePartParse(builder, parser);
            if (res != GroovyElementTypes.WRONGWAY) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done((IElementType)res);
                return PathExpression.parseAfterReference(builder, parser, newMarker);
            }
            builder.error(GroovyBundle.message("path.selector.expected", new Object[0]));
            marker.drop();
            return result;
        }
        if (PathExpression.checkForLParenth(builder)) {
            PrimaryExpression.methodCallArgsParse(builder, parser);
            return PathExpression.parseAfterArguments(builder, marker, parser);
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            PathExpression.appendedBlockParse(builder, parser);
            return PathExpression.parseAfterArguments(builder, marker, parser);
        }
        if (PathExpression.checkForArrayAccess(builder)) {
            PathExpression.indexPropertyArgsParse(builder, parser);
            PsiBuilder.Marker newMarker = marker.precede();
            marker.done((IElementType)GroovyElementTypes.PATH_INDEX_PROPERTY);
            return PathExpression.parseAfterReference(builder, parser, newMarker);
        }
        marker.drop();
        return result;
    }

    private static Result parseAfterReference(PsiBuilder builder, GroovyParser parser, PsiBuilder.Marker newMarker) {
        if (PathExpression.checkForLCurly(builder)) {
            PsiBuilder.Marker argsMarker = builder.mark();
            argsMarker.done((IElementType)GroovyElementTypes.ARGUMENTS);
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            return PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
        }
        return PathExpression.pathElementParse(builder, newMarker, parser, Result.INVOKED_EXPR);
    }

    private static Result parseAfterArguments(PsiBuilder builder, PsiBuilder.Marker marker, GroovyParser parser) {
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            return PathExpression.pathElementParse(builder, marker, parser, Result.METHOD_CALL);
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)GroovyElementTypes.PATH_METHOD_CALL);
        return PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
    }

    private static boolean checkForLCurly(PsiBuilder builder) {
        return ParserUtils.lookAhead(builder, GroovyTokenTypes.mLCURLY) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mLCURLY);
    }

    private static boolean checkForLParenth(PsiBuilder builder) {
        return builder.getTokenType() == GroovyTokenTypes.mLPAREN;
    }

    public static boolean checkForArrayAccess(PsiBuilder builder) {
        return builder.getTokenType() == GroovyTokenTypes.mLBRACK && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mCOLON) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mNLS, GroovyTokenTypes.mCOLON);
    }

    public static GroovyElementType namePartParse(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, GroovyTokenTypes.mAT);
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT) || ParserUtils.getToken(builder, GroovyTokenTypes.mSTRING_LITERAL) || ParserUtils.getToken(builder, GroovyTokenTypes.mGSTRING_LITERAL)) {
            return GroovyElementTypes.REFERENCE_EXPRESSION;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, null, GroovyElementTypes.GSTRING, GroovyBundle.message("string.end.expected", new Object[0]));
            return result ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
        }
        if (tokenType == GroovyTokenTypes.mREGEX_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mREGEX_LITERAL, GroovyElementTypes.REGEX, GroovyBundle.message("regex.end.expected", new Object[0]));
            return result ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, GroovyElementTypes.REGEX, GroovyBundle.message("dollar.slash.end.expected", new Object[0]));
            return result ? GroovyElementTypes.PATH_PROPERTY_REFERENCE : GroovyElementTypes.REFERENCE_EXPRESSION;
        }
        if (tokenType == GroovyTokenTypes.mLCURLY) {
            OpenOrClosableBlock.parseOpenBlock(builder, parser);
            return GroovyElementTypes.PATH_PROPERTY_REFERENCE;
        }
        if (tokenType == GroovyTokenTypes.mLPAREN) {
            PrimaryExpression.parenthesizedExprParse(builder, parser);
            return GroovyElementTypes.PATH_PROPERTY_REFERENCE;
        }
        if (TokenSets.KEYWORDS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return GroovyElementTypes.REFERENCE_EXPRESSION;
        }
        return GroovyElementTypes.WRONGWAY;
    }

    public static GroovyElementType indexPropertyArgsParse(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == GroovyTokenTypes.mLBRACK);
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mLBRACK);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ArgumentList.parseArgumentList(builder, GroovyTokenTypes.mRBRACK, parser);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        marker.done((IElementType)GroovyElementTypes.ARGUMENTS);
        return GroovyElementTypes.PATH_INDEX_PROPERTY;
    }

    private static IElementType appendedBlockParse(PsiBuilder builder, GroovyParser parser) {
        return OpenOrClosableBlock.parseClosableBlock(builder, parser);
    }

    private static boolean isPathElementStart(PsiBuilder builder) {
        return PATH_ELEMENT_START.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mDOT) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mLCURLY);
    }

    public static enum Result {
        INVOKED_EXPR,
        METHOD_CALL,
        WRONG_WAY,
        LITERAL;

    }
}

