/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GroovyTypeParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GrTypeArgumentList, PsiTypeParameter, GrTypeElement> {
    private static final Set<Class> ALLOWED_PARENT_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GrCodeReferenceElement.class});
    private static final Set<Class> STOP_SEARCHING_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GroovyFile.class});

    public GrTypeElement[] getActualParameters(GrTypeArgumentList o) {
        return o.getTypeArgumentElements();
    }

    public IElementType getActualParameterDelimiterType() {
        return GroovyTokenTypes.mCOMMA;
    }

    public IElementType getActualParametersRBraceType() {
        return GroovyTokenTypes.mGT;
    }

    public Set<Class> getArgumentListAllowedParentClasses() {
        return ALLOWED_PARENT_CLASSES;
    }

    public Set<? extends Class> getArgListStopSearchClasses() {
        return STOP_SEARCHING_CLASSES;
    }

    public Class<GrTypeArgumentList> getArgumentListClass() {
        return GrTypeArgumentList.class;
    }

    public boolean couldShowInLookup() {
        return false;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public Object[] getParametersForDocumentation(PsiTypeParameter p, ParameterInfoContext context) {
        return new Object[]{p};
    }

    public GrTypeArgumentList findElementForParameterInfo(CreateParameterInfoContext context) {
        GrTypeArgumentList parameterList = (GrTypeArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), GrTypeArgumentList.class);
        if (parameterList != null) {
            if (!(parameterList.getParent() instanceof GrCodeReferenceElement)) {
                return null;
            }
            GrCodeReferenceElement ref = (GrCodeReferenceElement)parameterList.getParent();
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            Object[] typeParams = ((PsiTypeParameterListOwner)resolved).getTypeParameters();
            if (typeParams.length == 0) {
                return null;
            }
            context.setItemsToShow(typeParams);
            return parameterList;
        }
        return null;
    }

    public void showParameterInfo(GrTypeArgumentList element, CreateParameterInfoContext context) {
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public GrTypeArgumentList findElementForUpdatingParameterInfo(UpdateParameterInfoContext context) {
        return (GrTypeArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), GrTypeArgumentList.class);
    }

    public void updateParameterInfo(GrTypeArgumentList parameterOwner, UpdateParameterInfoContext context) {
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType());
        context.setCurrentParameter(index);
        Object[] objectsToView = context.getObjectsToView();
        context.setHighlightedParameter(index < objectsToView.length && index >= 0 ? (PsiElement)objectsToView[index] : null);
    }

    public String getParameterCloseChars() {
        return ",>";
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    public void updateUI(PsiTypeParameter p, ParameterInfoUIContext context) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append(" extends ");
        buffer.append(StringUtil.join((Object[])p.getSuperTypes(), (Function)new Function<PsiClassType, String>(){

            public String fun(PsiClassType t) {
                return t.getPresentableText();
            }
        }, (String)", "));
        context.setupUIComponentPresentation(buffer.toString(), 0, highlightEndOffset, false, false, false, context.getDefaultParameterColor());
    }
}

