/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocParameterReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;

public class GrDocParameterReferenceImpl
extends GroovyDocPsiElementImpl
implements GrDocParameterReference {
    public GrDocParameterReferenceImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        return "GrDocParameterReference";
    }

    public PsiReference getReference() {
        return this;
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ASTNode node;
        String name = this.getName();
        if (name == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        ArrayList<GroovyResolveResultImpl> candidates = new ArrayList<GroovyResolveResultImpl>();
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner(this);
        if (owner instanceof GrMethod) {
            GrParameter[] parameters;
            GrMethod method = (GrMethod)owner;
            for (GrParameter parameter : parameters = method.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                candidates.add(new GroovyResolveResultImpl(parameter, true));
            }
            return candidates.toArray(new ResolveResult[candidates.size()]);
        }
        PsiElement firstChild = this.getFirstChild();
        if (owner instanceof GrTypeParameterListOwner && firstChild != null && (node = firstChild.getNode()) != null && GroovyDocTokenTypes.mGDOC_TAG_VALUE_LT.equals(node.getElementType())) {
            PsiTypeParameter[] typeParameters;
            for (PsiTypeParameter typeParameter : typeParameters = ((PsiTypeParameterListOwner)owner).getTypeParameters()) {
                if (!name.equals(typeParameter.getName())) continue;
                candidates.add(new GroovyResolveResultImpl((PsiElement)typeParameter, true));
            }
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public String getName() {
        return this.getText();
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length != 1) {
            return null;
        }
        return results[0].getElement();
    }

    public String getCanonicalText() {
        return this.getName();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode node = this.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        if (this.isReferenceTo(element)) {
            return this;
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof GrParameter) && !(element instanceof GrTypeParameter)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    public Object[] getVariants() {
        ASTNode node;
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner(this);
        PsiElement firstChild = this.getFirstChild();
        if (owner instanceof GrTypeParameterListOwner && firstChild != null && (node = firstChild.getNode()) != null && GroovyDocTokenTypes.mGDOC_TAG_VALUE_LT.equals(node.getElementType())) {
            return ((PsiTypeParameterListOwner)owner).getTypeParameters();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public GrDocTagValueToken getReferenceNameElement() {
        GrDocTagValueToken token = (GrDocTagValueToken)this.findChildByClass(GrDocTagValueToken.class);
        assert (token != null);
        return token;
    }
}

