/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.jarFinder;

import com.intellij.jarFinder.FindJarFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyFindJarFix
extends FindJarFix<GrReferenceElement> {
    public GroovyFindJarFix(GrReferenceElement ref) {
        super((PsiElement)ref);
    }

    protected Collection<String> getFqns(GrReferenceElement ref) {
        GrImportStatement[] importList;
        GrImportStatement importStatement = (GrImportStatement)PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), GrImportStatement.class);
        if (importStatement != null) {
            GrCodeReferenceElement reference = importStatement.getImportReference();
            if (reference != null) {
                return Collections.singleton(reference.getText());
            }
            return Collections.emptyList();
        }
        if (ref.getQualifier() != null) {
            return Collections.emptyList();
        }
        String className = ref.getReferenceName();
        if (className == null) {
            return Collections.emptyList();
        }
        PsiFile file = ref.getContainingFile().getOriginalFile();
        if (!(file instanceof GroovyFile)) {
            return Collections.emptyList();
        }
        for (GrImportStatement imp : importList = ((GroovyFile)file).getImportStatements()) {
            if (!className.equals(imp.getImportedName())) continue;
            GrCodeReferenceElement importReference = imp.getImportReference();
            if (importReference == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(importReference.getText());
        }
        return Collections.emptyList();
    }
}

