/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class ImportOnDemandIntention
extends Intention {
    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (!(element instanceof GrReferenceElement)) {
            return;
        }
        GrReferenceElement ref = (GrReferenceElement)element;
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiClass)) {
            return;
        }
        String qname = ((PsiClass)resolved).getQualifiedName();
        GrImportStatement importStatement = GroovyPsiElementFactory.getInstance(project).createImportStatementFromText(qname, true, true, null);
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof GroovyFile)) {
            return;
        }
        ((GroovyFile)containingFile).addImport(importStatement);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)resolved, (SearchScope)new LocalSearchScope((PsiElement)containingFile))) {
            PsiElement parent;
            PsiElement refElement = reference.getElement();
            if (refElement == null || !((parent = refElement.getParent()) instanceof GrQualifiedReference)) continue;
            GrReferenceAdjuster.shortenReference((GrQualifiedReference)parent);
        }
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof GrReferenceElement)) {
                    return false;
                }
                GrReferenceElement ref = (GrReferenceElement)element;
                PsiElement parent = ref.getParent();
                if (!(parent instanceof GrReferenceElement)) {
                    return false;
                }
                PsiElement resolved = ref.resolve();
                if (resolved == null) {
                    return false;
                }
                return resolved instanceof PsiClass;
            }
        };
    }
}

