/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class GrSetStrongTypeIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrSetStrongTypeIntention.class);

    @Override
    protected void processIntention(PsiElement element, Project project, final Editor editor) throws IncorrectOperationException {
        PsiElement elementToBuildTemplate;
        GrVariable[] variables;
        PsiElement parent = element.getParent();
        if (parent instanceof GrVariable && parent.getParent() instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent.getParent()).getVariables();
            elementToBuildTemplate = parent.getParent();
        } else if (parent instanceof GrVariable && parent.getParent() instanceof GrForInClause) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent.getParent().getParent();
        } else if (parent instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent).getVariables();
            elementToBuildTemplate = parent;
        } else if (parent instanceof GrParameter && parent.getParent() instanceof GrParameterList) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent.getParent().getParent();
        } else if (parent instanceof GrVariable) {
            variables = new GrVariable[]{(GrVariable)parent};
            elementToBuildTemplate = parent;
        } else {
            return;
        }
        ArrayList<SupertypeConstraint> types = new ArrayList<SupertypeConstraint>();
        if (parent.getParent() instanceof GrForInClause) {
            types.add(SupertypeConstraint.create(PsiUtil.extractIteratedType((GrForInClause)parent.getParent())));
        } else {
            for (GrVariable variable : variables) {
                PsiParameter parameter;
                PsiType type;
                PsiType type2;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer != null && (type2 = initializer.getType()) != null) {
                    types.add(SupertypeConstraint.create(type2));
                }
                if (!(variable instanceof GrParameter) || (type = GrSetStrongTypeIntention.getClosureParameterType(parameter = (PsiParameter)variable)) == null) continue;
                types.add(SupertypeConstraint.create(type));
            }
        }
        final String originalText = elementToBuildTemplate.getText();
        final TypeInfo typeInfo = GrSetStrongTypeIntention.getOrCreateTypeElement(parent, elementToBuildTemplate);
        PsiElement replaceElement = typeInfo.elementToReplace;
        TypeConstraint[] constraints = types.toArray(new TypeConstraint[types.size()]);
        ChooseTypeExpression chooseTypeExpression = new ChooseTypeExpression(constraints, element.getManager(), replaceElement.getResolveScope());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(elementToBuildTemplate);
        builder.replaceElement(replaceElement, (Expression)chooseTypeExpression);
        final Document document = editor.getDocument();
        final RangeMarker rangeMarker = document.createRangeMarker(elementToBuildTemplate.getTextRange());
        rangeMarker.setGreedyToRight(true);
        rangeMarker.setGreedyToLeft(true);
        PsiElement afterPostprocess = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)elementToBuildTemplate);
        Template template = builder.buildTemplate();
        TextRange range = afterPostprocess.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                if (brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            if (rangeMarker.isValid()) {
                                document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)originalText);
                                editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset() + typeInfo.originalOffset);
                            }
                        }
                    });
                }
            }
        });
    }

    private static PsiType getClosureParameterType(PsiParameter parameter) {
        PsiElement scope = parameter.getDeclarationScope();
        PsiType type = scope instanceof GrClosableBlock ? ClosureParameterEnhancer.inferType((GrClosableBlock)scope, ((GrParameterList)parameter.getParent()).getParameterIndex(parameter)) : null;
        return type;
    }

    private static TypeInfo getOrCreateTypeElement(PsiElement parent, PsiElement elementToBuildTemplateOn) {
        int nameElementOffset;
        GrModifierList modifierList = GrSetStrongTypeIntention.getModifierList(parent);
        if (modifierList != null && modifierList.hasModifierProperty("def") && modifierList.getModifiers().length == 1) {
            PsiElement modifier = PsiUtil.findModifierInList(modifierList, "def");
            LOG.assertTrue(modifier != null);
            int modifierOffset = modifier.getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
            return new TypeInfo(modifier, modifierOffset);
        }
        PsiClassType typeToUse = TypesUtil.createType("Abc", parent);
        if (elementToBuildTemplateOn instanceof GrVariableDeclaration) {
            GrVariableDeclaration decl = (GrVariableDeclaration)elementToBuildTemplateOn;
            decl.setType((PsiType)typeToUse);
            nameElementOffset = decl.getModifierList().getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        } else {
            GrVariable var = (GrVariable)parent;
            var.setType((PsiType)typeToUse);
            nameElementOffset = var.getNameIdentifierGroovy().getTextRange().getStartOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        }
        return new TypeInfo(GrSetStrongTypeIntention.getTypeElement(parent), nameElementOffset);
    }

    private static GrTypeElement getTypeElement(PsiElement parent) {
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getTypeElementGroovy();
        }
        return ((GrVariableDeclaration)parent).getTypeElementGroovy();
    }

    private static GrModifierList getModifierList(PsiElement parent) {
        GrModifierList modifierList = parent instanceof GrVariable ? ((GrVariable)parent).getModifierList() : ((GrVariableDeclaration)parent).getModifierList();
        return modifierList;
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement pparent;
                PsiElement parent = element.getParent();
                if (this.isNameIdentifierOfVariable(element, parent) || this.isModifierListOfVar(element, parent)) {
                    pparent = parent.getParent();
                } else if (this.isModifierListOfVarDecl(element, parent)) {
                    pparent = parent;
                } else {
                    return false;
                }
                if (pparent instanceof GrVariableDeclaration) {
                    GrVariable[] variables;
                    if (((GrVariableDeclaration)pparent).getTypeElementGroovy() != null) {
                        return false;
                    }
                    for (GrVariable variable : variables = ((GrVariableDeclaration)pparent).getVariables()) {
                        if (!GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable)) continue;
                        return true;
                    }
                } else {
                    if (pparent instanceof GrForInClause) {
                        GrVariable variable = ((GrForInClause)pparent).getDeclaredVariable();
                        return variable != null && variable.getTypeElementGroovy() == null && PsiUtil.extractIteratedType((GrForInClause)pparent) != null;
                    }
                    if (parent instanceof GrParameter && pparent instanceof GrParameterList) {
                        return ((GrParameter)parent).getTypeElementGroovy() == null && GrSetStrongTypeIntention.getClosureParameterType((PsiParameter)parent) != null;
                    }
                    GrVariable variable = (GrVariable)parent;
                    return variable.getTypeElementGroovy() == null && GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable);
                }
                return false;
            }

            private boolean isModifierListOfVarDecl(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getModifierList() == element;
            }

            private boolean isModifierListOfVar(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariable && ((GrVariable)parent).getModifierList() == element;
            }

            private boolean isNameIdentifierOfVariable(PsiElement element, PsiElement parent) {
                return parent instanceof GrVariable && ((GrVariable)parent).getTypeElementGroovy() == null && element == ((GrVariable)parent).getNameIdentifierGroovy();
            }
        };
    }

    private static boolean isVarDeclaredWithInitializer(GrVariable variable) {
        GrExpression initializer = variable.getInitializerGroovy();
        return initializer != null && initializer.getType() != null;
    }

    private static class TypeInfo {
        final PsiElement elementToReplace;
        final int originalOffset;

        TypeInfo(PsiElement element, int offset) {
            this.originalOffset = offset;
            this.elementToReplace = element;
        }
    }
}

