/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrRemoveExplicitTypeDeclarationIntention
extends Intention {
    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        PsiElement parent = element.getParent();
        if (parent instanceof GrVariable) {
            ((GrVariable)parent).setType(null);
        } else if (parent instanceof GrVariableDeclaration) {
            ((GrVariableDeclaration)parent).setType(null);
        } else if (parent instanceof GrMethod) {
            ((GrMethod)parent).setReturnType(null);
        }
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement parent = element.getParent();
                if (element instanceof GrTypeElement || element instanceof GrModifierList) {
                    return parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getTypeElementGroovy() != null || parent instanceof GrMethod && ((GrMethod)parent).getReturnTypeElementGroovy() != null;
                }
                if (parent instanceof GrNamedElement && ((GrNamedElement)parent).getNameIdentifierGroovy().equals(element)) {
                    if (parent instanceof GrVariable) {
                        return ((GrVariable)parent).getTypeElementGroovy() != null;
                    }
                    if (parent instanceof GrMethod && ((GrMethod)parent).findSuperMethods().length == 0) {
                        return ((GrMethod)parent).getReturnTypeElementGroovy() != null;
                    }
                }
                return false;
            }
        };
    }
}

