/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class EachToForIntention
extends Intention {
    public static final String OUTER = "Outer";
    public static final String HINT = "Replace with For-In";

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new EachToForPredicate();
    }

    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        int index;
        String var;
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        GrClosableBlock block = expression.getClosureArguments()[0];
        GrParameterList parameterList = block.getParameterList();
        GrParameter[] parameters = parameterList.getParameters();
        if (parameters.length == 1) {
            var = parameters[0].getText();
            var = StringUtil.replace((String)var, (String)"def", (String)"");
        } else {
            var = "it";
        }
        GrExpression invokedExpression = expression.getInvokedExpression();
        GrExpression qualifier = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(element.getProject());
        if (qualifier == null) {
            qualifier = elementFactory.createExpressionFromText("this");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("for (").append(var).append(" in ").append(qualifier.getText()).append(") {\n");
        String text = block.getText();
        PsiElement blockArrow = block.getArrow();
        for (index = blockArrow != null ? blockArrow.getStartOffsetInParent() + blockArrow.getTextLength() : 1; index < text.length() && Character.isWhitespace(text.charAt(index)); ++index) {
        }
        text = text.substring(index, text.length() - 1);
        builder.append(text);
        builder.append("}");
        GrStatement statement = elementFactory.createStatementFromText(builder.toString());
        GrForStatement forStatement = (GrForStatement)expression.replaceWithStatement(statement);
        GrForClause clause = forStatement.getClause();
        GrVariable variable = clause.getDeclaredVariable();
        forStatement = EachToForIntention.updateReturnStatements(forStatement);
        if (variable == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = documentManager.getDocument(element.getContainingFile());
        if (doc == null) {
            return;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(doc);
        editor.getCaretModel().moveToOffset(variable.getTextOffset());
        new VariableInplaceRenamer((PsiNamedElement)variable, editor).performInplaceRename();
    }

    private static GrForStatement updateReturnStatements(GrForStatement forStatement) {
        String continueText;
        GrStatement body = forStatement.getBody();
        assert (body != null);
        final HashSet usedLabels = ContainerUtil.newHashSet();
        final Ref needLabel = Ref.create((Object)false);
        body.accept(new GroovyRecursiveElementVisitor(){
            private int myLoops = 0;

            @Override
            public void visitReturnStatement(GrReturnStatement returnStatement) {
                if (returnStatement.getReturnValue() != null) {
                    return;
                }
                if (this.myLoops > 0) {
                    needLabel.set((Object)true);
                }
            }

            @Override
            public void visitLabeledStatement(GrLabeledStatement labeledStatement) {
                super.visitLabeledStatement(labeledStatement);
                usedLabels.add(labeledStatement.getName());
            }

            @Override
            public void visitForStatement(GrForStatement forStatement) {
                ++this.myLoops;
                super.visitForStatement(forStatement);
                --this.myLoops;
            }

            @Override
            public void visitWhileStatement(GrWhileStatement whileStatement) {
                ++this.myLoops;
                super.visitWhileStatement(whileStatement);
                --this.myLoops;
            }

            @Override
            public void visitClosure(GrClosableBlock closure) {
            }

            @Override
            public void visitAnonymousClassDefinition(GrAnonymousClassDefinition anonymousClassDefinition) {
            }
        });
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(forStatement.getProject());
        if (((Boolean)needLabel.get()).booleanValue()) {
            int i = 0;
            String label = OUTER;
            while (usedLabels.contains(label)) {
                label = OUTER + i;
                ++i;
            }
            continueText = "continue " + label;
            GrLabeledStatement labeled = (GrLabeledStatement)factory.createStatementFromText(label + ": while (true){}");
            labeled.getStatement().replaceWithStatement(forStatement);
            labeled = (GrLabeledStatement)forStatement.replaceWithStatement(labeled);
            forStatement = (GrForStatement)labeled.getStatement();
            body = forStatement.getBody();
            assert (body != null);
        } else {
            continueText = "continue";
        }
        final GrStatement continueStatement = factory.createStatementFromText(continueText);
        body.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReturnStatement(GrReturnStatement returnStatement) {
                if (returnStatement.getReturnValue() == null) {
                    returnStatement.replaceWithStatement(continueStatement);
                }
            }

            @Override
            public void visitClosure(GrClosableBlock closure) {
            }

            @Override
            public void visitAnonymousClassDefinition(GrAnonymousClassDefinition anonymousClassDefinition) {
            }
        });
        return forStatement;
    }

    private static class EachToForPredicate
    implements PsiElementPredicate {
        private EachToForPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            GrReferenceExpression referenceExpression;
            GrMethodCallExpression expression;
            GrExpression invokedExpression;
            if (element instanceof GrMethodCallExpression && (invokedExpression = (expression = (GrMethodCallExpression)element).getInvokedExpression()) instanceof GrReferenceExpression && "each".equals((referenceExpression = (GrReferenceExpression)invokedExpression).getReferenceName())) {
                GrClosableBlock[] closureArguments;
                GrArgumentList argumentList = expression.getArgumentList();
                if (argumentList != null) {
                    if (PsiImplUtil.hasExpressionArguments(argumentList)) {
                        return false;
                    }
                    if (PsiImplUtil.hasNamedArguments(argumentList)) {
                        return false;
                    }
                }
                if ((closureArguments = expression.getClosureArguments()).length != 1) {
                    return false;
                }
                GrParameter[] parameters = closureArguments[0].getParameterList().getParameters();
                return parameters.length <= 1;
            }
            return false;
        }
    }
}

