/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.gant.GantRunner;
import org.jetbrains.plugins.groovy.gant.GantSettings;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GantScriptType
extends GroovyRunnableScriptType {
    public static final String DEFAULT_EXTENSION = "gant";
    public static final GroovyScriptType INSTANCE = new GantScriptType();

    private GantScriptType() {
        super(DEFAULT_EXTENSION);
    }

    @Override
    public Icon getScriptIcon() {
        return JetgroovyIcons.Groovy.Gant_16x16;
    }

    @Override
    public GroovyScriptRunner getRunner() {
        return new GantRunner();
    }

    @Override
    public boolean isConfigurationByLocation(GroovyScriptRunConfiguration existing, Location place) {
        String params = existing.getScriptParameters();
        String targetName = GantScriptType.getTargetName(place);
        if (targetName == null) {
            return StringUtil.isEmpty((String)params);
        }
        return params != null && (params.startsWith(targetName + " ") || params.equals(targetName));
    }

    private static String getTargetName(Location location) {
        PsiElement parent = location.getPsiElement();
        while (!(parent.getParent() instanceof PsiFile) && parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCallExpression)parent, "target")) {
            GrArgumentLabel label;
            GrNamedArgument[] args = ((GrMethodCallExpression)parent).getNamedArguments();
            if (args.length == 1 && (label = args[0].getLabel()) != null) {
                return label.getName();
            }
            return null;
        }
        return null;
    }

    @Override
    public void tuneConfiguration(GroovyFile file, GroovyScriptRunConfiguration configuration, Location location) {
        String target = GantScriptType.getTargetName(location);
        if (target != null) {
            configuration.setScriptParameters(target);
            configuration.setName(configuration.getName() + "." + target);
        }
        RunManagerEx.disableTasks((Project)file.getProject(), (RunConfiguration)configuration, (Key[])new Key[]{CompileStepBeforeRun.ID, CompileStepBeforeRunNoErrorCheck.ID});
    }

    public static List<VirtualFile> additionalScopeFiles(GroovyFile file) {
        String sdkHome;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null && (sdkHome = GantUtils.getSdkHomeFromClasspath(module)) != null) {
            return Collections.emptyList();
        }
        GantSettings gantSettings = GantSettings.getInstance(file.getProject());
        VirtualFile home = gantSettings.getSdkHome();
        if (home == null) {
            return Collections.emptyList();
        }
        return gantSettings.getClassRoots();
    }

    @Override
    public GlobalSearchScope patchResolveScope(GroovyFile file, GlobalSearchScope baseScope) {
        return baseScope.uniteWith((GlobalSearchScope)new NonClasspathDirectoriesScope(GantScriptType.additionalScopeFiles(file)));
    }
}

