/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitField;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GroovyTraitFieldSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public GroovyTraitFieldSearcher() {
        super(true);
    }

    public void processQuery(ReferencesSearch.SearchParameters p, Processor<PsiReference> consumer) {
        PsiClass aClass;
        PsiElement target = p.getElementToSearch();
        if (target instanceof GrField && !(target instanceof GrTraitField) && GrTraitUtil.isTrait(aClass = ((GrField)target).getContainingClass())) {
            String traitFieldName = GrTraitUtil.getTraitFieldPrefix(aClass) + ((GrField)target).getName();
            p.getOptimizer().searchWord(traitFieldName, p.getEffectiveSearchScope(), (short)1, true, target, (RequestResultProcessor)new MyProcessor(target));
        }
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        private final PsiElement myTarget;
        private final PsiManager myManager;

        public MyProcessor(PsiElement target) {
            super(new Object[0]);
            this.myTarget = target;
            this.myManager = this.myTarget.getManager();
        }

        public boolean processTextOccurrence(PsiElement element, int offsetInElement, Processor<PsiReference> consumer) {
            PsiField prototype;
            PsiElement resolved;
            PsiElement parent = element.getParent();
            return !(parent instanceof GrReferenceExpression) || element != ((GrReferenceExpression)parent).getReferenceNameElement() || !((resolved = ((GrReferenceExpression)parent).resolve()) instanceof GrTraitField) || !this.myManager.areElementsEquivalent((PsiElement)(prototype = ((GrTraitField)resolved).getPrototype()), resolved) || consumer.process((Object)((PsiReference)parent));
        }
    }
}

