/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.plugins.groovy.findUsages.GroovyWordsScanner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;

public class GroovyFindUsagesProvider
implements FindUsagesProvider {
    public static final GroovyFindUsagesProvider INSTANCE = new GroovyFindUsagesProvider();

    public WordsScanner getWordsScanner() {
        return new GroovyWordsScanner();
    }

    public boolean canFindUsagesFor(PsiElement psiElement) {
        return psiElement instanceof PsiClass || psiElement instanceof PsiMethod || psiElement instanceof GrVariable;
    }

    public String getHelpId(PsiElement psiElement) {
        return null;
    }

    public String getType(PsiElement element) {
        if (element instanceof PsiClass) {
            return "class";
        }
        if (element instanceof PsiMethod) {
            return "method";
        }
        if (element instanceof PsiField) {
            return "field";
        }
        if (element instanceof PsiParameter) {
            return "parameter";
        }
        if (element instanceof GrBindingVariable) {
            return "script binding variable";
        }
        if (element instanceof PsiVariable) {
            return "variable";
        }
        if (element instanceof GrLabeledStatement) {
            return "label";
        }
        if (element instanceof PropertyForRename) {
            return "property";
        }
        if (element instanceof GrClosableBlock) {
            return "closure";
        }
        return "";
    }

    public String getDescriptiveName(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            return qName == null ? "" : qName;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String result = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            PsiClass clazz = method.getContainingClass();
            if (clazz != null) {
                result = result + " of " + this.getDescriptiveName((PsiElement)clazz);
            }
            return result;
        }
        if (element instanceof PsiVariable) {
            String name = ((PsiVariable)element).getName();
            if (name != null) {
                return name;
            }
        } else {
            if (element instanceof GrLabeledStatement) {
                return ((GrLabeledStatement)element).getName();
            }
            if (element instanceof PropertyForRename) {
                return ((PropertyForRename)element).getPropertyName();
            }
            if (element instanceof GrClosableBlock) {
                return "closure";
            }
        }
        return "";
    }

    public String getNodeText(PsiElement element, boolean useFullName) {
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name != null) {
                return name;
            }
        } else {
            String name;
            if (element instanceof PsiMethod) {
                return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            }
            if (element instanceof PsiVariable && (name = ((PsiVariable)element).getName()) != null) {
                return name;
            }
        }
        return "";
    }
}

