/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class AccessorReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public AccessorReferencesSearcher() {
        super(true);
    }

    public void processQuery(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        if (element instanceof PsiMethod) {
            String propertyName = GroovyPropertyUtils.getPropertyName((PsiMethod)element);
            if (propertyName == null) {
                return;
            }
            queryParameters.getOptimizer().searchWord(propertyName, GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope()), (short)1, true, element);
        } else if (element instanceof GrField) {
            for (GrAccessorMethod method : ((GrField)element).getGetters()) {
                MethodReferencesSearch.search((PsiMethod)method, (SearchScope)queryParameters.getEffectiveSearchScope(), (boolean)true).forEach(consumer);
            }
            GrAccessorMethod setter = ((GrField)element).getSetter();
            if (setter != null) {
                MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)queryParameters.getEffectiveSearchScope(), (boolean)true).forEach(consumer);
            }
        }
    }
}

