/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStatementMover
extends StatementUpDownMover {
    public boolean checkAvailable(Editor editor, PsiFile file, StatementUpDownMover.MoveInfo info, boolean down) {
        Project project = file.getProject();
        if (!HandlerUtils.canBeInvoked(editor, project) || !(file instanceof GroovyFileBase)) {
            return false;
        }
        LineRange range = GroovyStatementMover.getLineRangeFromSelection((Editor)editor);
        Document document = editor.getDocument();
        int offset = document.getLineStartOffset(range.startLine);
        GrLiteral literal = (GrLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, GrLiteral.class, (boolean)false);
        if (literal != null && literal.textContains('\n')) {
            return false;
        }
        GroovyPsiElement pivot = GroovyStatementMover.getElementToMove((GroovyFileBase)file, offset);
        if (pivot == null) {
            return false;
        }
        LineRange pivotRange = GroovyStatementMover.getLineRange(pivot);
        range = new LineRange(Math.min(range.startLine, pivotRange.startLine), Math.max(range.endLine, pivotRange.endLine));
        GroovyPsiElement scope = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)pivot, (Class[])new Class[]{GrMethod.class, GrTypeDefinitionBody.class, GroovyFileBase.class});
        boolean stmtLevel = GroovyStatementMover.isStatement(pivot);
        boolean topLevel = pivot instanceof GrTypeDefinition && pivot.getParent() instanceof GroovyFileBase;
        List<LineRange> allRanges = this.allRanges(scope, stmtLevel, topLevel);
        LineRange prev = null;
        LineRange next = null;
        for (LineRange each : allRanges) {
            if (each.endLine <= range.startLine) {
                prev = each;
            }
            if (each.containsLine(range.startLine)) {
                range = new LineRange(each.startLine, range.endLine);
            }
            if (each.startLine < range.endLine && each.endLine > range.endLine) {
                range = new LineRange(range.startLine, each.endLine);
            }
            if (each.startLine < range.endLine || next != null) continue;
            next = each;
        }
        info.toMove = range;
        info.toMove2 = down ? next : prev;
        return true;
    }

    private static GroovyPsiElement getElementToMove(GroovyFileBase file, int offset) {
        GrDocCommentOwner owner;
        offset = CharArrayUtil.shiftForward((CharSequence)file.getText(), (int)offset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, GrDocComment.class);
        if (docComment != null && (owner = docComment.getOwner()) != null) {
            element = owner;
        }
        if (element instanceof PsiComment) {
            element = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        }
        return (GroovyPsiElement)PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element11) {
                return GroovyStatementMover.isMoveable(element11);
            }
        });
    }

    private List<LineRange> allRanges(GroovyPsiElement scope, final boolean stmtLevel, final boolean topLevel) {
        final ArrayList<LineRange> result = new ArrayList<LineRange>();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            int lastStart = -1;

            private void addRange(int endLine) {
                if (this.lastStart >= 0) {
                    result.add(new LineRange(this.lastStart, endLine));
                }
                this.lastStart = endLine;
            }

            public void visitElement(PsiElement element) {
                if (stmtLevel && element instanceof GrCodeBlock) {
                    PsiElement lBrace = ((GrCodeBlock)element).getLBrace();
                    if (GroovyStatementMover.nlsAfter(lBrace)) {
                        assert (lBrace != null);
                        this.addRange(new LineRange((PsiElement)lBrace).endLine);
                    }
                    this.addChildRanges(((GrCodeBlock)element).getStatements());
                    PsiElement rBrace = ((GrCodeBlock)element).getRBrace();
                    if (GroovyStatementMover.nlsAfter(rBrace)) {
                        assert (rBrace != null);
                        int endLine = new LineRange((PsiElement)rBrace).endLine;
                        if (this.lastStart >= 0) {
                            for (int i = this.lastStart + 1; i < endLine; ++i) {
                                this.addRange(i);
                            }
                        }
                    }
                } else if (stmtLevel && element instanceof GrCaseSection) {
                    GrCaseLabel[] allLabels = ((GrCaseSection)element).getCaseLabels();
                    GrCaseLabel label = allLabels[0];
                    if (GroovyStatementMover.nlsAfter(label)) {
                        this.addRange(new LineRange((PsiElement)label).endLine);
                    }
                    this.addChildRanges(((GrCaseSection)element).getStatements());
                } else if (element instanceof GroovyFileBase) {
                    this.addChildRanges(((GroovyFileBase)element).getTopStatements());
                } else if (!stmtLevel && !topLevel && element instanceof GrTypeDefinitionBody) {
                    this.addChildRanges(((GrTypeDefinitionBody)element).getMemberDeclarations());
                } else {
                    super.visitElement(element);
                }
            }

            private boolean shouldDigInside(GrTopStatement statement) {
                if (stmtLevel && (statement instanceof GrMethod || statement instanceof GrTypeDefinition)) {
                    return false;
                }
                return !(statement instanceof GrVariableDeclaration) || stmtLevel;
            }

            private void addChildRanges(GrTopStatement[] statements) {
                for (int i = 0; i < statements.length; ++i) {
                    GrTopStatement statement = statements[i];
                    if (!GroovyStatementMover.nlsAfter(statement)) continue;
                    LineRange range = GroovyStatementMover.getLineRange(statement);
                    if ((i == 0 || GroovyStatementMover.isStatement(statements[i - 1])) && GroovyStatementMover.isStatement(statement)) {
                        for (int j = this.lastStart; j < range.startLine; ++j) {
                            this.addRange(j + 1);
                        }
                    }
                    this.lastStart = range.startLine;
                    if (this.shouldDigInside(statement)) {
                        statement.accept((PsiElementVisitor)this);
                    }
                    this.addRange(range.endLine);
                }
            }
        });
        return result;
    }

    private static boolean nlsAfter(PsiElement element) {
        String text;
        if (element == null) {
            return false;
        }
        PsiElement sibling = element;
        do {
            if ((sibling = PsiTreeUtil.nextLeaf((PsiElement)sibling)) == null) {
                return true;
            }
            text = sibling.getText();
            if (!text.contains("\n")) continue;
            return text.charAt(CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t")) == '\n';
        } while (sibling instanceof PsiComment || StringUtil.isEmptyOrSpaces((String)text) || text.equals(";"));
        return false;
    }

    private static boolean isMoveable(PsiElement element) {
        return GroovyStatementMover.isStatement(element) || GroovyStatementMover.isMemberDeclaration(element);
    }

    private static boolean isMemberDeclaration(PsiElement element) {
        return element instanceof GrMembersDeclaration || element instanceof GrTypeDefinition;
    }

    private static boolean isStatement(PsiElement element) {
        return element instanceof GrStatement && PsiUtil.isExpressionStatement(element);
    }

    private static LineRange getLineRange(GroovyPsiElement pivot) {
        GrDocComment comment;
        if (pivot instanceof GrDocCommentOwner && (comment = ((GrDocCommentOwner)pivot).getDocComment()) != null) {
            return new LineRange((PsiElement)comment, (PsiElement)pivot);
        }
        return new LineRange((PsiElement)pivot);
    }
}

