/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

@State(name="DslActivationStatus", storages={@Storage(file="$APP_CONFIG$/dslActivation.xml", roamingType=RoamingType.DISABLED)})
public class DslActivationStatus
implements PersistentStateComponent<Element> {
    private final Map<VirtualFile, String> myStatus = new THashMap();
    private static final String ENABLED = "enabled";

    public static DslActivationStatus getInstance() {
        return (DslActivationStatus)ServiceManager.getService(DslActivationStatus.class);
    }

    public synchronized void activateUntilModification(VirtualFile vfile) {
        this.myStatus.put(vfile, ENABLED);
    }

    public synchronized void disableFile(VirtualFile vfile, String error) {
        this.myStatus.put(vfile, error);
    }

    public synchronized String getInactivityReason(VirtualFile file) {
        String status = this.myStatus.get(file);
        return ENABLED.equals(status) ? null : status;
    }

    public synchronized boolean isActivated(VirtualFile file) {
        String status = this.myStatus.get(file);
        if (status == null) {
            this.myStatus.put(file, ENABLED);
            return true;
        }
        return ENABLED.equals(status);
    }

    public synchronized Element getState() {
        Element root = new Element("x");
        for (Map.Entry<VirtualFile, String> entry : this.myStatus.entrySet()) {
            VirtualFile file = entry.getKey();
            String status = entry.getValue();
            Element element = new Element("file");
            root.addContent(element);
            element.setAttribute("url", file.getUrl());
            if (ENABLED.equals(status)) continue;
            element.setAttribute("status", status);
        }
        return root;
    }

    public synchronized void loadState(Element state) {
        List children = state.getChildren("file");
        for (Element element : children) {
            String url = element.getAttributeValue("url", "");
            String status = element.getAttributeValue("status");
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file == null) continue;
            this.myStatus.put(file, StringUtil.isNotEmpty((String)status) ? status : ENABLED);
        }
    }
}

